#include <liberic_misc.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_OEM_BOARD_NAME,
	cfgkey:		"device.devname"
    },
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int board_name_asp(int eid, webs_t wp, int argc, char **argv);
static int support_homepage_asp(int eid, webs_t wp, int argc, char **argv);

int
oem_misc_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("boardName", board_name_asp);
    websAspDefine("supportHomePage", support_homepage_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_OEM_MISC, ACL_OBJ_OEM);

    fh->post_validate_hook = post_validate_hook;
    
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
board_name_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char* boardname = eric_misc_get_boardname();
#if defined(PP_FEAT_PDU)
    char* name;
    char* modelname;
    if (PP_ERR == pp_cfg_get_nodflt(&modelname, "device.model")) {
	modelname = strdup("unknown");
    }
    asprintf(&name, "%s (%s)", boardname, modelname);
    ejSetResult(eid, name);
    free(modelname);
    free(name);
#else
    ejSetResult(eid, boardname);
#endif
    free(boardname);
    return 0;
}

static int
support_homepage_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char* homepage;
    if (PP_SUCCED(pp_cfg_get(&homepage, "support_homepage"))) {
        ejSetResult(eid, homepage);
    }
    free(homepage);
    return 0;
}

static int
post_validate_hook(webs_t wp UNUSED,  form_handler_t * fh)
{
    if (*fh->fv[FV_ID_OEM_BOARD_NAME].val.s == '\0') {
	fh->fv[FV_ID_OEM_BOARD_NAME].flags |= FV_FLAG_DONT_SAVE;
	pp_cfg_remove(fh->fv[FV_ID_OEM_BOARD_NAME].cfgkey);
    }
    return 0;
}
