#include <pp/powerswitch.h>
#include <pp/cfg.h>
#include <pp/intl.h>
#include <liberic_config.h>
#include "eric_forms.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

int
power_control_common_tmpl_init(void)
{
    return 0;
}

int
power_control_common_power_switch_login(webs_t wp, u_int port_id)
{
    char var_name[MAX_OPT_KEY_LEN + 1];
    char var_value[MAX_OPT_VALUE_LEN + 1];
    const char * serial_port_name;
    const char * serial_opt_name;
    const char * serial_name;
    char * serial_opt_val=NULL;
    char * switch_name;
    char * power_name;
    const char * current_device_id;
    int ext_is_enabled, cnt, i, device_id, ret = PP_ERR;

    if (port_id == PP_POWER_PORT_ID_SERIAL_1) {
	serial_port_name = "serial port 1";
	serial_opt_name = "serialport[0]._c_";
	serial_name = "serial1";
	current_device_id = websGetVar(wp, "current_power_device_serial1", NULL);
    } else if (port_id == PP_POWER_PORT_ID_SERIAL_2) {
	serial_port_name = "serial port 2";
	serial_opt_name = "serialport[1]._c_";
	serial_name = "serial2";
	current_device_id = websGetVar(wp, "current_power_device_serial2", NULL);
    } else {
	assert(0);
	return PP_ERR;
    }

    pp_cfg_get(&serial_opt_val, "%s", serial_opt_name);
    ext_is_enabled = !pp_strcmp_safe(serial_opt_val, "externalpower");
    free(serial_opt_val);

    /* fill the power entry list for choosen serial port */    
    if (ext_is_enabled) {
	/* open the power switch */
	ret = pp_power_login(port_id);

	/* on error set an error message */
	if (PP_SUCCED(ret)) {
	    /* set variable with switch name */
	    switch_name = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_SHORT_NAME, port_id);
	    if (switch_name) {
		snprintf(var_name, sizeof(var_name), "_ps_name_%s", serial_name);
		websSetVar(wp, var_name, switch_name);
		free(switch_name);
	    }

	    cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, port_id);
	    snprintf(var_name, sizeof(var_name), "power_device_%s_cnt", serial_name);
	    snprintf(var_value, sizeof(var_value), "%d", cnt);
	    websSetVar(wp, var_name, var_value);
	    if (cnt > 0) {
		for (i = 0; i < cnt; i++) {
		    snprintf(var_name, sizeof(var_name), "power_device_%s%c%u",
                             serial_name, fv_vec_idx_deli, i);
		    power_name = pp_power_get_name(0, i, PWR_OBJ_DEVICE, port_id);
		    websSetVar(wp, var_name, power_name);
		    free(power_name);
		}
	    }
	    device_id = pp_strtoul_10(current_device_id, 0, NULL);
	    cnt = pp_power_get_count(device_id, PWR_OBJ_PORT, port_id);
	    if (cnt > 0) {
		snprintf(var_name, sizeof(var_name), "power_entry_%s_cnt", serial_name);
		snprintf(var_value, sizeof(var_value), "%u", cnt);
		websSetVar(wp, var_name, var_value);
		for (i = 0; i < cnt; i++) {	    
		    snprintf(var_name, sizeof(var_name), "power_entry_%s%c%u",
                             serial_name, fv_vec_idx_deli, i);
		    power_name = pp_power_get_name(i, device_id, PWR_OBJ_PORT, port_id);
		    websSetVar(wp, var_name, power_name);
		    free(power_name);        	
		}
	    }
	} else {
	    snprintf(var_name, sizeof(var_name), "_ps_err_msg_%s", serial_name);
	    if (ret < PP_SUC) {
		snprintf(var_value, sizeof(var_value), _("Connection to power switch on %s failed."), serial_port_name);
	    } else if (ret > PP_SUC) {
		snprintf(var_value, sizeof(var_value), _("Power switch on %s is busy. Please try again later."), serial_port_name);
	    }
	    websSetVar(wp, var_name, var_value);
	}
    } else {
	snprintf(var_name, sizeof(var_name), "_ps_err_msg_%s", serial_name);
	snprintf(var_value, sizeof(var_value), _("No power switch configured on %s."), serial_port_name);
    }

    return ret;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_common_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
