#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/intl.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

FV_SPEC = {
};

static int post_save_hook(webs_t wp, form_handler_t * fh);

int
power_control_intern_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CONTROL_INTERN, ACL_OBJ_POWER_CONTROL);

    fh->post_save_hook = post_save_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    unsigned int port_id = 0;
    int res;
#if defined(PP_FEAT_PCI_ADC)
    int host_pwrsupplypower;
#endif /* PP_FEAT_PCI_ADC */

    if ((form_button_clicked(wp, "action_server_reset")
	 || form_button_clicked(wp, "action_power_short")
	 || form_button_clicked(wp, "action_power_long"))) {
#if defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4) || defined(PRODUCT_LARA) || defined (PRODUCT_ASMIDC) && defined (OEM_LENOVO)
	port_id = PP_POWER_PORT_ID_INTERNAL;
#else
	port_id = PP_POWER_PORT_ID_SERIAL_2;
#endif

#if defined(PP_FEAT_PCI_ADC)
	if (eric_misc_get_host_pwrsupplypower(&host_pwrsupplypower) != -1) {
	    if (host_pwrsupplypower) {
		if (form_button_clicked(wp, "action_server_reset")) {
		    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_reset(0, 0, port_id));
		    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
				 "Reset %s.", res ? "failed" : "performed");
		} else {
		    int short_press = form_button_clicked(wp, "action_power_short");
		    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_switch(0, 0, short_press, 0, port_id));
		    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
				 "Power switch %s.", res ? "failed" : "performed");
		}
	    } else {
		if (form_button_clicked(wp, "action_server_reset")) {
		    set_response(wp, ERIC_RESPONSE_ERROR, "Reset failed because the server has no power !");
		} else {
		    set_response(wp, ERIC_RESPONSE_ERROR, "Power switch failed because the server has no power !");
		}
	    }
	}

#else  
	if (form_button_clicked(wp, "action_server_reset")) {
	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_reset(0, 0, port_id));
	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 _("Reset %s."), res ? _("failed") : _("performed"));
	} else {
	    int short_press = form_button_clicked(wp, "action_power_short");
	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_switch(0, 0, short_press, 0, port_id));
	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 _("Power switch %s."), res ? _("failed") : _("performed"));
	}
#endif
	pp_power_logout(port_id);
    }

    
    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_intern_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
