#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/intl.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"
#include "templates.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

FV_SPEC = {
};

static int post_save_hook(webs_t wp, form_handler_t * fh);

int
power_control_ipmi_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CONTROL_IPMI, ACL_OBJ_POWER_CONTROL);

    fh->post_save_hook = post_save_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (form_button_clicked(wp, "action_cancel_ipmi_power_on") ||
        form_button_clicked(wp, "action_cancel_ipmi_power_off") ||
        form_button_clicked(wp, "action_cancel_ipmi_reset")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Power Control via IPMI cancelled."));
    } else if (form_button_clicked(wp, "action_ipmi_power_on")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Power On' if you really want to power on the computer!"));
        websSetVar(wp, "_show_ipmi_power_on_confirm", "1");
    } else if (form_button_clicked(wp, "action_ipmi_power_off")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Power Off' if you really want to power off the computer!"));
        websSetVar(wp, "_show_ipmi_power_off_confirm", "1");
    } else if (form_button_clicked(wp, "action_ipmi_reset")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Reset' if you really want to reset the computer!"));
        websSetVar(wp, "_show_ipmi_reset_confirm", "1");
    } else if (form_button_clicked(wp, "action_really_ipmi_reset")) {	    
	if (ipmi_chassis_power_control(wp, PP_IPMI_CHASSIS_RESET, NULL) == -1) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Reset via IPMI failed."));
	    return -1;
	} else {
	    set_response(wp, ERIC_RESPONSE_OK, _("Reset via IPMI done."));	
	}
    } else {
	int ipmi_power;
	if (form_button_clicked(wp, "action_really_ipmi_power_on")) {
	    ipmi_power = PP_IPMI_CHASSIS_POWER_UP;
	} else if (form_button_clicked(wp, "action_really_ipmi_power_off")) {
	    ipmi_power = PP_IPMI_CHASSIS_POWER_DOWN;
	} else {
	    /* No control via IPMI */
	    return 0;
	}

	if (ipmi_chassis_power_control(wp, ipmi_power, NULL) == -1) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Power Control via IPMI failed."));
	    return -1;
	} else {
	    set_response(wp, ERIC_RESPONSE_OK, _("Power Control via IPMI done."));
	}
    }
    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_ipmi_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
