#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

 FV_SPEC = {
    {
	id:		FV_ID_PS_POWER_CYCLE_OFFTIME,
	cfgkey:		"ps.power_cycle_offtime"
    },
 };

static int post_save_hook(webs_t wp, form_handler_t * fh);

int
power_control_psu_adapt_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CONTROL_PSU_ADAPT, ACL_OBJ_POWER_CONTROL);

    fh->post_save_hook = post_save_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    unsigned int port_id = 0;
    int res;
#if defined(PP_FEAT_PCI_ADC)
    int host_pwrsupplypower;
#endif /* PP_FEAT_PCI_ADC */

    port_id = PP_POWER_PORT_ID_PSU_ADAPT;
	
/*     if (form_button_clicked(wp, "action_stdby_on")) { */
/* 	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_stdby_switch(0, 0, 1, 0, port_id)); */
/* 	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK, "Standby-Cycle %s.", res ? "failed" : "performed"); */
/*     } */

/*     if (form_button_clicked(wp, "action_stdby_off")) { */
/* 	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_stdby_switch(0, 0, 0, 0, port_id)); */
/* 	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK, "Standby-Cycle %s.", res ? "failed" : "performed"); */
/*     } */
	
    if ((form_button_clicked(wp, "action_power_cycle")
	 || form_button_clicked(wp, "action_power_on")
	 || form_button_clicked(wp, "action_power_off"))) {

#if defined(PP_FEAT_PCI_ADC)
	if (eric_misc_get_host_pwrsupplypower(&host_pwrsupplypower) != -1) {
	   if (host_pwrsupplypower) {
	       if (form_button_clicked(wp, "action_power_cycle")) {
		   res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_cycle(0, 0, port_id));
		   set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 "Power cycle %s.", res ? "failed" : "performed");
	       } else {
		   int power_on = form_button_clicked(wp, "action_power_on");
		   res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_switch(0, 0, power_on, 0, port_id));
		   set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 "Power switch %s.", res ? "failed" : "performed");
	       }
	   } else {
	       if (form_button_clicked(wp, "action_power_cycle")) {
		   set_response(wp, ERIC_RESPONSE_ERROR, "Power cycle failed because the server has no power !");
	       } else {
		   set_response(wp, ERIC_RESPONSE_ERROR, "Power switch failed because the server has no power !");
	       }
	   }
	}
#else
	if (form_button_clicked(wp, "action_power_cycle")) {
	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_cycle(0, 0, port_id));
	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 "Power cycle %s.", res ? "failed" : "performed");
	} else {
	    int power_on = form_button_clicked(wp, "action_power_on");
	    res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_switch(0, 0, power_on, 0, port_id));
	    set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
			 "Power switch %s.", res ? "failed" : "performed");
	}	
#endif
	
	pp_power_logout(port_id);
    }

    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_psu_adapt_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
