#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

 FV_SPEC = {
 };

static int post_save_hook(webs_t wp, form_handler_t * fh);

int
power_control_state_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CONTROL_STATE, ACL_OBJ_POWER_CONTROL);

    fh->post_save_hook = post_save_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp UNUSED, form_handler_t * fh UNUSED)
{
    return PP_SUC;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_state_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
