#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#if defined(PP_FEAT_POWER_CTRL_ENABLE)

FV_SPEC = {
    {
	id:		FV_ID_PS_POWER_CYCLE_OFFTIME,
	cfgkey:		"ps.power_cycle_offtime"
    },
    {
	id:		FV_ID_PS_POWER_BUTTON_ENABLED,
	cfgkey:		"ps.power_button_enabled"
    },
    {
	id:		FV_ID_PS_POWER_STDBY_OFFTIME,
	cfgkey:		"ps.power_stdby_offtime"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
power_cycle_offtime_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CYCLE_OFFTIME, ACL_OBJ_POWER_SWITCH);

    fh->pre_validate_hook = pre_validate_hook;
    
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
    
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    int res;
    unsigned int port_id = 0;

    char * enabled_str = get_form_var_value_unsaved(wp, TEMPLATE_POWER_SWITCH, FV_ID_PS_PSU_ADAPT_ENABLED);
    if (pp_strcmp_safe(enabled_str, "yes")) fh_disable_validate_and_save(fh, -1);

    port_id = PP_POWER_PORT_ID_PSU_ADAPT;
    
    enabled_str = get_form_var_value_unsaved(wp, TEMPLATE_POWER_CYCLE_OFFTIME, FV_ID_PS_POWER_BUTTON_ENABLED);

        res = PP_FAILED(pp_power_login(port_id)) || PP_FAILED(pp_power_button(0, 0, !pp_strcmp_safe(enabled_str, "yes") ? 1 : 0 , 0, port_id));
        set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
    		 "Setting option %s.", res ? "failed" : "done");

    free(enabled_str);
    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_cycle_offtime_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
