#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/intl.h>
#include <pp/powerswitch.h>
#include <liberic_config.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

FV_SPEC = {
};

static int get_pswitch_status(webs_t wp, u_int dev_id, unsigned int port_id);
static int pswitch_init_form_vars_asp(int eid, webs_t wp, int argc, char ** argv);

int
pswitch_status_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("pswitchInitFormVars", pswitch_init_form_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_PSWITCH_STATUS, ACL_OBJ_POWER_SWITCH);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pswitch_init_form_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char ** argv UNUSED)
{
    const char * dev_id_str;
    char btn_name[64];
    char var[64];
    u_int i, dev_id = 0, dev_cnt = 0;
#if defined(PRODUCT_XX01IP_ANY)
    u_int port_id = PP_POWER_PORT_ID_SERIAL_1;
#else
    u_int port_id = PP_POWER_PORT_ID_SERIAL_2;
#endif

#if defined(PRODUCT_XX01IP_ANY)
    pp_cfg_get_uint_nodflt(&dev_cnt, "ps.serial[0].smart._s_");
#else
    pp_cfg_get_uint_nodflt(&dev_cnt, "ps.serial[1].smart._s_");
#endif
    
    pp_power_login(port_id);
    for (i = 0; i < dev_cnt; ++i) {
	char * val = pp_power_get_name(0, i, PWR_OBJ_DEVICE, port_id);
	/* device name  */
	pp_log("Device Name %d: %s\n", i, val);
	snprintf(var, sizeof(var), "_device_name_%d", i);
	websSetVar(wp, var, val ? val : "Unknown");
	free(val);
    }
    dev_id_str = websGetVar(wp, "__power_unit__", "0");
    dev_id = pp_strtoul_10(dev_id_str, 0, NULL);
    websSetVar(wp, "__power_unit__", dev_id_str);

    snprintf(btn_name, sizeof(btn_name), "action_power_ext1_%u_on", i);
    if (form_button_clicked(wp, btn_name)) {
	pp_log("action_power_ext1_%u_on\n", i);
	pp_power_ext_switch(PWR_EXT_1, dev_id, 1, port_id);
    }
    snprintf(btn_name, sizeof(btn_name), "action_power_ext1_%u_off", i);
    if (form_button_clicked(wp, btn_name)) {
	pp_log("action_power_ext1_%u_off\n", i);
	pp_power_ext_switch(PWR_EXT_1, dev_id, 0, port_id);
    }
    snprintf(btn_name, sizeof(btn_name), "action_power_ext2_%u_on", i);
    if (form_button_clicked(wp, btn_name)) {
	pp_log("action_power_ext2_%u_on\n", i);
	pp_power_ext_switch(PWR_EXT_2, dev_id, 1, port_id);
    }
    snprintf(btn_name, sizeof(btn_name), "action_power_ext2_%u_off", i);
    if (form_button_clicked(wp, btn_name)) {
	pp_log("action_power_ext2_%u_off\n", i);
	pp_power_ext_switch(PWR_EXT_2, dev_id, 0, port_id);
    }
    get_pswitch_status(wp, dev_id, port_id);
    pp_power_logout(port_id);
    return 0;
}

#define DEV_TYPE_1X8      0x00
#define DEV_TYPE_2X4      0x01
static int
get_pswitch_status(webs_t wp, u_int dev_id, unsigned int port_id)
{
    int ret;
    int dev_type;
    const char *val_const;
    char * val;

    /* device name  */
    val = pp_power_get_name(0, dev_id, PWR_OBJ_DEVICE, port_id);	
    websSetVar(wp, "_sel_device_name", val ? val : "Unknown");
    free(val);

    /* device type */
    /* FIXME: is hardcoding "smart" appropriate? */
#if defined(PRODUCT_XX01IP_ANY)
    if (PP_FAILED(pp_cfg_get_nodflt(&val, "ps.serial[0].smart[%u].dev_type", dev_id)))
#else
    if (PP_FAILED(pp_cfg_get_nodflt(&val, "ps.serial[1].smart[%u].dev_type", dev_id)))
#endif
    {
	websSetVar(wp, "_error_msg", _("Device type not set!"));
	return 0;
    }
    dev_type = !pp_strcmp_safe(val, "2x4") ? DEV_TYPE_2X4 : DEV_TYPE_1X8;	    
    free(val);

    /* temperature */
    val = pp_power_get_temperature(dev_id, port_id);
    if (val) {
	websSetVar(wp, "_device_temperature", val);
    } else {
	websSetVar(wp, "_error_msg", _("Device not found!"));
	free(val);
	return 0;
    }
    free(val);

    /* voltage channel a */
    val = pp_power_get_data(dev_id, PWR_CHANNEL_A, PWR_DATA_VOLTAGE, port_id);    
    websSetVar(wp, "_device_voltage_a", val ? val : _("Unknown"));
    free(val);

    /* current channel a */
    val = pp_power_get_data(dev_id, PWR_CHANNEL_A, PWR_DATA_CURRENT, port_id);
    websSetVar(wp, "_device_current_a", val ? val : _("Unknown"));
    free(val);

#if 0
    /* line frequency channel a */
    val = pp_power_get_data(dev_id, PWR_CHANNEL_A, PWR_DATA_FREQ, port_id);
    websSetVar(wp, "_device_freq_a", val ? val : _("Unknown"));
    free(val);
#endif    

    /* 2x4 devices only */
    if (dev_type == DEV_TYPE_2X4) {

	/* voltage channel b */
	val = pp_power_get_data(dev_id, PWR_CHANNEL_B, PWR_DATA_VOLTAGE, port_id);
	websSetVar(wp, "_device_voltage_b", val ? val : _("Unknown"));
	free(val);

	/* current channel b */
	val = pp_power_get_data(dev_id, PWR_CHANNEL_B, PWR_DATA_CURRENT, port_id);
	websSetVar(wp, "_device_current_b", val ? val : _("Unknown"));
	free(val);

#if 0	
	/* line frequency channel b */
	snprintf(var, sizeof(var), "_device_freq_b");
	val = pp_power_get_data(dev_id, PWR_CHANNEL_B, PWR_DATA_FREQ, port_id);
	websSetVar(wp, "_device_freq_b", val ? val : _("Unknown"));
	free(val);
#endif    
    }

    ret = pp_power_get_ext_state(PWR_EXT_1, dev_id, port_id);
    if	    (ret == 0) val_const = _("Off");
    else if (ret == 1) val_const = _("On");
    else if (ret == 2) val_const = _("Monitor Undervolt.");
    else if (ret == 3) val_const = _("Monitor Overcurr.");
    else if (ret == 4) val_const = _("Monitor Overtemp.");
    else	       val_const = _("Unknown");
    websSetVar(wp, "_device_ext1_state", val_const);

    ret = pp_power_get_ext_state(PWR_EXT_2, dev_id, port_id);
    if	    (ret == 0) val_const = _("Off");
    else if (ret == 1) val_const = _("On");
    else if (ret == 2) val_const = _("Monitor Undervolt.");
    else if (ret == 3) val_const = _("Monitor Overcurr.");
    else if (ret == 4) val_const = _("Monitor Overtemp.");
    else	       val_const = _("Unknown");
    websSetVar(wp, "_device_ext2_state", val_const);

    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int pswitch_status_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
