#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_RC_HOME_AUTO_REFRESH,
	cfgkey:		"home_auto_refresh",
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
rc_home_refresh_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_RC_HOME_REFRESH, ACL_OBJ_ANYONE);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (!form_button_clicked(wp, "action_apply")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }
    return 0;
}


