#include <liberic_misc.h>
#include <pp/intl.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:             FV_ID_RC_MOUSESYNC_KEY,
	cfgkey:         "user[%U].rc.mousesync.key",
    },
    {
        id:             FV_ID_RC_MOUSESYNC_KEYCODE,
        cfgkey:         "user[%U].rc.mousesync.code",
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int post_save_hook(webs_t wp, form_handler_t * fh);

int
rc_mouse_hotkey_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_RC_MOUSE_HOTKEY, ACL_OBJ_RC_HOTKEYS);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;
    fh->post_save_hook = post_save_hook;
    fh->disable_ldap=TRUE;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (!form_button_clicked(wp, "action_apply")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    form_var_t * fv_hk = &fh->fv[FV_ID_RC_MOUSESYNC_KEY];
    form_var_t * fv_hkc = &fh->fv[FV_ID_RC_MOUSESYNC_KEYCODE];
    char * hkc_var_val;
    if (translate_hotkey(wp, fv_hk->val.s, &hkc_var_val, NULL,
			 fv_hk->label, KEYPARSER_WITHOUT_DELIS) < 0) {
        return -1;
    }
    websSetVar(wp, fv_hkc->fvname, hkc_var_val);
    fv_hkc->val.s = websGetVar(wp, fv_hkc->fvname, "");
    free(hkc_var_val);
    return 0;
}

static int
post_save_hook(webs_t wp, form_handler_t * fh)
{
    if (fh->fv[FV_ID_RC_MOUSESYNC_KEY].val.s[0] == '\0'
        && !form_var_is_disabled(wp, &fh->fv[FV_ID_RC_MOUSESYNC_KEY])) {
        set_response(wp, ERIC_RESPONSE_OK,_("Operation completed successfully.<br>\n Single mouse mode not possible, because no Mouse hotkey defined."));
    }
    return 0;
}
