#include <pp/grab.h>
#include <pp/kvm.h>
#include <pp/vsc.h>
#include <pp/rfb.h>
#include <pp/intl.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "ej.h"

FV_SPEC = {
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int rc_update_preview_asp(int eid, webs_t wp, int argc, char ** argv);
static int rc_get_info_asp(int eid, webs_t wp, int argc, char ** argv);

int
rc_preview_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("rcUpdatePreview", rc_update_preview_asp);
    websAspDefine("rcGetInfo", rc_get_info_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_RC_PREVIEW, ACL_OBJ_RC);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (form_button_clicked(wp, "action_preview_refresh")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }

    return 0;
}

static int
rc_update_preview_asp(int eid UNUSED, webs_t wp, int argc UNUSED,
		      char **argv UNUSED)
{
#if !defined(PRODUCT_FLASHX4)
    u_char unit;
    u_short port;
    
    pp_kvm_get_unit_port_for_video_link(0, &unit, &port);
    if (pp_kvm_is_port_allowed_for_user(wp->user, unit, port)) {
	int ret = pp_grab_create_snapshot(0, wp->user,
				          &wp->sd->screenshot_width,
				          &wp->sd->screenshot_height);
	switch (ret) {
	    case PP_SUC:
	        // okay, the screenshot is valid
	        break;
	    case PP_GRAB_SCREENSHOT_NO_SIGNAL:
	        websSetVar(wp, "_screenshot_result", _("No Signal"));
	        break;
	    case PP_GRAB_SCREENSHOT_NOT_POSSIBLE:
	        websSetVar(wp, "_screenshot_result", _("Auto adjustment in progress, screenshot currently not available, please refresh later"));
	        break;
	    case PP_GRAB_SCREENSHOT_UNKNOWN_MODE:
	        websSetVar(wp, "_screenshot_result", _("Unknown Video Mode"));
	        break;
	    case PP_GRAB_SCREENSHOT_EXCL_ACCESS:
	        websSetVar(wp, "_screenshot_result", _("Exclusive Access active for other user"));
	        break;
	    case PP_GRAB_SCREENSHOT_ERROR:
	    default:
	        websSetVar(wp, "_screenshot_result", _("Error while taking screenshot"));
	        break;
	}
    } else {
	websSetVar(wp, "_screenshot_result", _("No Permission"));
    }
#else /* PRODUCT_FLASHX4 */
    (void)wp;
#endif /* PRODUCT_FLASHX4 */
    return 0;
}

static int
rc_get_info_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
#if !defined(PRODUCT_FLASHX4)
    const char *excl_user;
    eric_session_int_id_t excl_sid;
    video_signal_state_t vsc_signal = pp_vsc_has_signal(0);
    vsc_output_state_t  vsc_output = pp_vsc_output_state(0);
    fb_format_info_t fb_f_info;
        
    /* check exclusive access */
    excl_sid = pp_rfb_get_excl_session(0);
    if (excl_sid != 0) {
	excl_user = eric_session_get_user(excl_sid);
	if (strncmp(wp->user, excl_user, ERIC_MAX_USER_LENGTH)) {
	    ejSetResult(eid, "no access");
	    goto bail;
	}
    }
  	 
    if (vsc_signal == VIDEO_SIGNAL_ON && vsc_output == OUTPUT_VALID) {
	char res[20];

	if (pp_grab_get_format_info(0, &fb_f_info) == 0) {
	    snprintf(res, sizeof(res), "%d x %d", fb_f_info.g_w, fb_f_info.g_h);
	    ejSetResult(eid, res);
	} else {
	    ejSetResult(eid, _("unknown"));
	}
    } else if (vsc_signal != VIDEO_SIGNAL_ON) {
	ejSetResult(eid, _("no signal"));
    } else {
	ejSetResult(eid, _("unknown"));
    }
  	 
 bail:
#else /* PRODUCT_FLASHX4 */
    (void)ej;
    (void)wp;
#endif /* PRODUCT_FLASHX4 */
    return 0;
}
