#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/km.h>
#include <pp/vsc.h>
#if defined(PP_FEAT_USB)
#include <pp/usb.h>
#endif /* PP_FEAT_USB */
#endif /* PP_FEAT_REMOTE_CONSOLE */
#include <pp/intl.h>
#include <liberic_misc.h>
#include <liberic_notify.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "wsIntrn.h"

FV_SPEC = {
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int km_is_reset_supported_asp(int eid, webs_t wp, int argc, char ** argv);

int
reset_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("kmIsResetSupported", km_is_reset_supported_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_RESET, ACL_OBJ_RESET, ACL_OBJ_RESET_PARTS);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
#if defined(PP_FEAT_REMOTE_CONSOLE)
    if (form_button_clicked(wp, "action_kme_reset")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	if (pp_km_reset_driver_is_implemented(0) && !pp_km_reset_driver(0)) {
	    pp_km_sync_mouse(0, PP_KM_MOUSE_SYNC_FAST);
	} else {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Could not reset keyboard/mouse"));
	    return -1;
	}
#if defined(PP_FEAT_USB)
    } else if (form_button_clicked(wp, "action_usb_reset")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	pp_usb_reset_device();
#endif /* !PP_FEAT_USB */
    } else if (form_button_clicked(wp, "action_vsc_reset")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	pp_vsc_reset(0,VSC_RESET_PROGRAM_FPGA);
    } else
#endif
    if (form_button_clicked(wp, "action_device_reset")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	set_response(wp, ERIC_RESPONSE_OK,_("Are you sure you want to restart the device?<br>Please confirm by pressing \"Really Reset\"."));
	websSetVar(wp, "_show_device_reset_confirm", "1");
    } else if (form_button_clicked(wp, "action_really_device_reset")) {
	int ret = device_reset(wp);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	if (ret == 0) {
	    char redirect[200];
	    int redirect_to;
	    pp_cfg_get_int(&redirect_to, "reset_redirect_time");
	    snprintf(redirect, sizeof(redirect),
	        "<meta http-equiv=\"refresh\" content=\"%d; URL=/\">",
	        60 * redirect_to);

	    set_response(wp, ERIC_RESPONSE_OK, _("The device will be reset in a few seconds."));
	    websSetVar(wp, "_show_redirect_info", "1");
	    websSetVar(wp, "__meta__", redirect);
	}
	return ret;
    } else if (form_button_clicked(wp, "action_cancel_device_reset")) {
	set_response(wp, ERIC_RESPONSE_OK, _("Reset operation cancelled."));
    }

    return 0;
}

static int
km_is_reset_supported_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
#if defined(PP_FEAT_REMOTE_CONSOLE)
    ejSetResult(eid, pp_km_reset_driver_is_implemented(0) ? "1" : "0");
#else
    ejSetResult(eid, "0");
#endif
    return 0;
}
