#ifndef __TMPL_RPC_COMMON_H__
#define __TMPL_RPC_COMMON_H__

#include <pp/bmc/bmc_dev_oem_pp_rpc_isens_nr.h>

/*** common methods **********************************************************/

//#define RPC_DEBUG_IPMI TWD // debug ipmi
#define RPC_DEBUG_IPMI(args...) // suppress ipmi debug

#define dontUSE_SDR_SENSOR_NAMES

#define OUTLET_SETUP_SENSORS(__outlet__, __power_branch__) { \
        RPC_RECEPTACLE_SENSOR_RMS_CURRENT(__outlet__), \
        RPC_POWER_BRANCH_SENSOR_RMS_VOLTAGE(__power_branch__) \
    }
#define OUTLET_SETUP_SENSOR_STRINGS { N_("Current"), N_("Voltage") }
    
extern const char *bmc_rpc_outlet_name_str;

typedef enum {
    STATE_FAILURE,                      // LED off
    STATE_RELAIS_ON_POWER_ON,           // LED red
    STATE_RELAIS_ON_POWER_CRITICAL,     // LED red flashing
    STATE_RELAIS_ON_POWER_OFF,          // LED yellow flashing
    STATE_RELAIS_OFF_POWER_ON,          // LED green
    STATE_RELAIS_OFF_POWER_OFF          // LED green flashing
} outlet_power_state_t;

int rpc_set_outlet_state(webs_t wp, unsigned char outlet, unsigned char state);
pp_ipmi_sdr_list_entry_t* get_sdr_entry_for_sensor(unsigned char sensornum);
int rpc_outlet_switch_hook(webs_t wp, form_handler_t * fh);
int rpc_get_power_branch_for_outlet(int outlet);
int rpc_get_relais_board_for_outlet(int outlet);
int rpc_get_outlet_state(int outlet);

#endif /* __TMPL_RPC_COMMON_H__ */
