/* system includes */
/* firmware includes */
#include <pp/ipmi.h>
#include <pp/hal_rpc.h>

/* local includes */
#include "webs.h"
#include "templates.h"
#include "eric_forms.h"
#include "tmpl_rpc_common.h"

FV_SPEC = {
};

static int init_outlet_state(webs_t wp, int idx);

/* ASPs */
static int rpc_init_all_outlet_states_asp(int eid, webs_t wp, 
                                          int argc, char **argv);

int rpc_outlet_list_tmpl_init(void)
{
    form_handler_t * fh;

    rpc_common_tmpl_init();
    
    /* register ASPs */
    websAspDefine("rpcInitAllOutletStates", rpc_init_all_outlet_states_asp);
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_RPC_OUTLET_LIST, ACL_OBJ_POWER_SWITCH);

    fh->pre_validate_hook = rpc_outlet_switch_hook;
    
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
    
    return PP_SUC;
}

static int rpc_init_all_outlet_states_asp(int eid UNUSED, webs_t wp, 
                                          int argc UNUSED, char **argv UNUSED) {
    int ret = PP_SUC;
    int i, outlets = pp_hal_rpc_get_no_outlets();
    
    for(i = 0; i < outlets; ++i) {
        ret |= init_outlet_state(wp, i);
    }
    
    websSetIntVar(wp, "num_outlets", pp_hal_rpc_get_no_outlets());
    websSetIntVar(wp, "num_rows", pp_hal_rpc_get_no_rows());
    
    return ret;
}

static int init_outlet_state(webs_t wp, int idx) {
    int ret = PP_SUC;
    int state = rpc_get_outlet_state(idx);
    const char *led_state[6] = { "off", "red", "red_flashing",
                                 "yellow_flashing", "green", "green_flashing" };
    char var_name[32];
    char *outlet_name = NULL;

    form_var_vec_name("outlet_led_state", idx + 1, var_name, 32);
    websSetVar(wp, var_name, led_state[state]);

    form_var_vec_name("outlet_name", idx + 1, var_name, 32);
    if(PP_ERR == pp_cfg_get_nodflt(&outlet_name, 
                                   bmc_rpc_outlet_name_str, idx)) {
        websSetVar(wp, var_name, "");
    } else {
        websSetVar(wp, var_name, outlet_name);
        free(outlet_name);
    }
    
    return ret;
}


