#include <liberic_cert.h>
#include <pp/um.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int cert_upload_cb(webs_t wp, char * name, char * filename, void * data,
			  size_t data_offset, size_t data_len, int more_data);

int
sec_server_cert_upload_tmpl_init(void)
{
    form_handler_t * fh;

    if (sec_server_cert_common_tmpl_init() != 0) return -1;
    
    /* register POST callbacks */
    websAddPostDataCallback("cert_file", cert_upload_cb);

    fh = CREATE_FH_INSTANCE(TEMPLATE_SEC_SERVER_CERT_UPLOAD, ACL_OBJ_SECURITY);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    int error;
       
    if (form_button_clicked(wp, "action_upload_cert")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	if (wp->cert_data_size > 0) {
	    eric_cert_install(wp->cert_data, wp->cert_data_size, &error);
	    if (error) {
		set_response(wp, ERIC_RESPONSE_ERROR, eric_cert_get_error_string(error));
		return -1;
	    }
	    /* reconfigure the net listener */ 
	    eric_net_reconf_listener();
	    set_response(wp, ERIC_RESPONSE_OK, _("Certificate installed successfully."));
	} else if (wp->response_msg == NULL) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Certificate File not found or empty."));
	    return -1;
	}
    }

    
    return 0;
}

static int
cert_upload_cb(webs_t wp, char * name UNUSED, char * filename UNUSED,
	       void * data, size_t data_offset UNUSED,  size_t data_len, int more_data)
{
    void * cd;

    eric_session_touch(wp->session);

    if(PP_ERR == pp_um_user_has_permission(wp->user, ACL_OBJ_SECURITY,
                                           pp_acl_raasip_yes_str)){
	set_response(wp, ERIC_RESPONSE_ERROR, perm_denied_msg);
	goto fail;
    }

    if (data_len > 0) {
	if ((wp->cert_data_size + data_len) > (ERIC_CERT_MAX_FILESIZE + 2)) {
	    set_response(wp, ERIC_RESPONSE_ERROR,
			 _("Certificate file too big (max. %u kB)."),
			 ERIC_CERT_MAX_FILESIZE / 1024);
	    goto fail;
	}
	if ((cd = brealloc(B_L, wp->cert_data,
			   wp->cert_data_size + data_len)) == NULL) {
	    set_response(wp, ERIC_RESPONSE_ERROR,
			 _("Not enough free memory for certificate."));
	    goto fail;
	}
	wp->cert_data = cd;
	memcpy(wp->cert_data + wp->cert_data_size, data, data_len);
	wp->cert_data_size += data_len;
    }

    if (data == NULL) {
	goto fail;
    } else if (!more_data && wp->cert_data_size >= 2) {
	wp->cert_data_size -= 2;
    }

    wp->upload_failed = 0;

    return 0;

 fail:
    free(wp->cert_data);
    wp->cert_data = NULL;
    wp->cert_data_size = 0;
    wp->upload_failed = 1;

    return -1;
}
