#ifdef PP_FEAT_MASS_STORAGE
#include <pp/usb.h>
#include <pp/intl.h>
#include <pp/um.h>
#include "tmpl_vfloppy_common.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "wsIntrn.h"

FV_SPEC = {
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int get_vfloppy_info_asp(int eid, webs_t wp, int argc, char **argv);

int
vfloppy_active_tmpl_init(void)
{
    form_handler_t * fh;

    if (vfloppy_common_tmpl_init() != 0) return -1;

    /* register ASPs */
    websAspDefine("getVFloppyInfo", get_vfloppy_info_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_VFLOPPY_ACTIVE, ACL_OBJ_VFLOPPY);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp,  form_handler_t * fh UNUSED)
{
    int error, ret = 0, is_root = 0;
    u_int ms_index;

    pp_um_user_is_root(&is_root, wp->user);
    
    for (ms_index = 0; ms_index < PP_FEAT_USB_MASS_STORAGE_NO; ++ms_index) {
	vfloppy_data_t * vfd = &vfloppy_data[ms_index];
    	char reactivate[48];
    	char download[48];
    	char unset[48];
     	char discard[48];
    	char disconnect[48];
    	
    	snprintf(reactivate, sizeof(reactivate), "action_vfloppy_reactivate_%u", ms_index);
    	snprintf(download, sizeof(download), "action_vfloppy_download_%u", ms_index);
    	snprintf(unset, sizeof(unset), "action_vfloppy_smb_unset_%u", ms_index);
    	snprintf(discard, sizeof(discard), "action_vfloppy_discard_%u", ms_index);
    	snprintf(disconnect, sizeof(disconnect), "action_vfloppy_msp_disconnect_%u", ms_index);
   	
    	if (form_button_clicked(wp, reactivate)) {
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	    if ( vfloppy_session_check(wp->session, ms_index, VFLOPPY_DISCARD_LAZY_SESSION_CHECK) || is_root ) {
		pp_usb_reset_device();
		set_response(wp, ERIC_RESPONSE_OK, _("Image file reactivated successfully"));
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, _("Uploaded Image belongs to another session!"));
		ret = -1;
	    }
	    break;
    	} else if (form_button_clicked(wp, download)) {
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	    if ( vfloppy_session_check(wp->session, ms_index, VFLOPPY_DISCARD_LAZY_SESSION_CHECK) ) {		
		strcpy(wp->type, "application/octet-stream");
		wp->numbytes = vfd->size;
		wp->download_fd = vfd->fd;
		wp->download_name = pp_usb_ms_get_image_info(ms_index, "name");
		wp->download_cb = vfloppy_download_cb;
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, _("Uploaded Image belongs to another session!"));
		ret = -1;
	    } 
	    break;
    	} else if (form_button_clicked(wp, unset)) {
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	    if ( vfloppy_session_check(wp->session, ms_index, VFLOPPY_DISCARD_LAZY_SESSION_CHECK) || is_root ) {
		if (pp_usb_ms_unset_image(ms_index, &error)) {
		    set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(error));
		    ret = -1;
		} else {
		    set_response(wp, ERIC_RESPONSE_OK, _("Image file unset successfully"));
		}
		vfloppy_discard(ms_index);
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, _("Uploaded Image belongs to another session!"));
		ret = -1;
	    } 
	    break;
    	} else if (form_button_clicked(wp, discard)) {
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	    if ( vfloppy_session_check(wp->session, ms_index, VFLOPPY_DISCARD_LAZY_SESSION_CHECK) || is_root ) {
		if (pp_usb_ms_unset_image(ms_index, &error)) {
		    set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(error));
		    ret = -1;
		} else {
		    set_response(wp, ERIC_RESPONSE_OK, _("Discarded the uploaded floppy image."));
		}
		vfloppy_discard(ms_index);
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, _("Uploaded Image belongs to another session!"));
		ret = -1;
	    }
	    break;
    	} else if (form_button_clicked(wp, disconnect)) {
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	    if ( vfloppy_session_check(wp->session, ms_index, VFLOPPY_DISCARD_LAZY_SESSION_CHECK) || is_root ) {
		if (pp_usb_ms_unset_image(ms_index, &error)) {
		    set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(error));
		    ret = -1;
		} else {
		    set_response(wp, ERIC_RESPONSE_OK, _("Disconnected the drive redirection."));
		}
		vfloppy_discard(ms_index);
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, _("Uploaded Image belongs to another session!"));
		ret = -1;
	    }
	    break;
    	} else {
	    continue;
    	}
    }
    return ret;
}

static int
get_vfloppy_info_asp(int eid, webs_t wp, int argc, char **argv)
{
    const char * res = NULL;
    char size_string[16];
    
    if (argc == 2) {
	u_int ms_index = pp_strtoul_10(argv[0], UINT_MAX, NULL);
	if (ms_index < PP_FEAT_USB_MASS_STORAGE_NO) {
	    vfloppy_data_t * vfd = &vfloppy_data[ms_index];

	    if (!strcmp(argv[1], "name")) {
		pp_usb_image_type_t at = pp_usb_ms_get_image_type(ms_index);
		if (at == PP_USB_MS_IMAGE_MSP) {
		    res = "Drive Redirection";
		} else if (at == PP_USB_MS_IMAGE_SMB) {
		    res = pp_usb_ms_get_image_info(ms_index, "path");
		} else {
		    res = pp_usb_ms_get_image_info(ms_index, "name");
		}
	    } else if (!strcmp(argv[1], "size")) {
		snprintf(size_string, sizeof(size_string), "%u", vfd->size);
		res = size_string;
	    } else if (!strcmp(argv[1], "host")) {
		res = pp_usb_ms_get_image_info(ms_index, "host");
	    } else if (!strcmp(argv[1], "share")) {
		res = pp_usb_ms_get_image_info(ms_index, "share");
	    } else if (!strcmp(argv[1], "path")) {
		res = pp_usb_ms_get_image_info(ms_index, "path");
	    } else if (!strcmp(argv[1], "user")) {
		res = pp_usb_ms_get_image_info(ms_index, "user");
	    } else if (!strcmp(argv[1], "redir_ip")) {
		res = pp_usb_ms_get_image_info(ms_index, "redir_ip");
	    } else if (!strcmp(argv[1], "redir_ro")) {
		res = pp_usb_ms_get_image_info(ms_index, "redir_ro");
	    } else if (!strcmp(argv[1], "redir_type")) {
		res = pp_usb_ms_get_image_info(ms_index, "redir_type");
	    } else if (!strcmp(argv[1], "type")) {
		pp_usb_image_type_t at;
		at = pp_usb_ms_get_image_type(ms_index);
		switch (at) {
		  case PP_USB_MS_IMAGE_MEM:
		      res = "file";
		      break;
		  case PP_USB_MS_IMAGE_SMB:
		      res = "smb";
		      break;
		  case PP_USB_MS_IMAGE_MSP:
		      res = "msp";
		      break;
		  default:
		      res = "none";
		      break;
		}
	    } else if (!strcmp(argv[1], "session_check")) {
		if ( vfd->owning_session == wp->session ) {
		    res = "own";
		} else {
		    res = "not_own";
		}
	    } else {
		res = "unknown";
	    }
	}
    }
    ejSetResult(eid, res ? res : "");

    return 0;
}
#endif /* PP_FEAT_MASS_STORAGE */
