#ifdef PP_FEAT_MASS_STORAGE
#include <pp/km.h>
#include "wsIntrn.h"
#include "templates.h"
#include "tmpl_vfloppy_common.h"

vfloppy_data_t vfloppy_data[PP_FEAT_USB_MASS_STORAGE_NO];

static int is_vfloppy_supported_asp(int eid, webs_t wp, int argc, char **argv);

int
vfloppy_common_tmpl_init(void)
{
    static int initialized = 0;

    if (!initialized) {
	memset(vfloppy_data, 0, sizeof(vfloppy_data));
	/* because of memsetting vfloppy_data to zero, vfloppy_data.filename
	   is initialized to a zero length string as well */
	websAspDefine("isVFloppySupported", is_vfloppy_supported_asp);
	initialized = 1;
    }

    return 0;
}

int
vfloppy_session_check(eric_session_int_id_t wp_session, u_int ms_index, u_int flags)
{
    vfloppy_data_t * vfd;

    assert(ms_index < PP_FEAT_USB_MASS_STORAGE_NO);

    vfd = &vfloppy_data[ms_index];
    
    if ((vfd->is_loaded && vfd->owning_session && wp_session
	&& ((flags & VFLOPPY_DISCARD_SKIP_SESSION_CHECK)
	    || vfd->owning_session == wp_session
	    || ((flags & VFLOPPY_DISCARD_LAZY_SESSION_CHECK)
		&& !strcmp(eric_session_get_user(vfd->owning_session),
			   eric_session_get_user(wp_session)))
	    )) || (vfd->owning_session == wp_session)) {
	pp_log("Discard VFloppy Image!\n");
	return 1;
    } else {
	return 0;
    }
}

void
vfloppy_discard(u_int ms_index)
{
    vfloppy_data_t * vfd;

    assert(ms_index < PP_FEAT_USB_MASS_STORAGE_NO);

    vfd = &vfloppy_data[ms_index];

    vfd->owning_session = 0;
    *vfd->name = '\0';
    vfd->size = 0;
    vfd->is_loaded = 0;
    if (strlen(vfd->filename) > 0) unlink(vfd->filename);
    *vfd->filename = '\0';
    close(vfd->fd);
    vfd->fd = -1;
}

static int
is_vfloppy_supported_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    ejSetResult(eid, pp_km_is_usb_possible(0) ? "1" : "0");
    return 0;
}
#endif /* PP_FEAT_MASS_STORAGE */
