#include <pp/intl.h>
#include <pp/vsc.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_VIDEO_LOCAL_PORT_SWITCH

FV_SPEC = {
    {
	id:		FV_ID_VIDEO_ENABLE_LOCAL,
	cfgkey:		"video.enable_local"
    }
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
video_local_port_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_VIDEO_LOCAL_PORT, ACL_OBJ_VIDEO);

    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    int state = !strcmp(fh->fv[FV_ID_VIDEO_ENABLE_LOCAL].val.s, "yes") ? 1 : 0;
    if (pp_vsc_set_local_video(0, state)) {
	set_response(wp, ERIC_RESPONSE_ERROR, _("Could not change state of local video port."));
	return -1;
    }
    return 0;
}

#else /* !PP_FEAT_VIDEO_LOCAL_PORT_SWITCH */

int video_local_port_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_VIDEO_LOCAL_PORT_SWITCH */
