/*
 * uemf.c -- GoAhead Micro Embedded Management Framework
 *
 * Copyright (c) GoAhead Software Inc., 1995-2000. All Rights Reserved.
 *
 * See the file "license.txt" for usage and redistribution license requirements
 */

/********************************* Description *******************************/

/*
 * This module provides compatibility with the full GoAhead EMF.
 * It is a collection of routines which permits the GoAhead WebServer to
 * run stand-alone and to also load as a solution pack under the GoAhead EMF.
 */

/********************************** Includes *********************************/

#include "uemf.h"

/***************************** Forward Declarations **************************/

/************************************ Code ***********************************/

/*
 * Convert integer to ascii string. Allow a NULL string in which case we
 * allocate a dynamic buffer. 
 */

char *
stritoa(int n, char *s, int width)
{
    char	*cp, *lim, *sp;
    char	buf[16];		/* Just temp to hold number */
    int		next, minus;

    a_assert(s && width > 0);

    if (s == NULL) {
	if (width == 0) {
	    width = 10;
	}
	if ((s = balloc(B_L, width + 1)) == NULL) {
	    return NULL;
	}
    }
    if (n < 0) {
	minus = 1;
	n = -n;
	width--;
    } else {
	minus = 0;
    }

    cp = buf;
    lim = &buf[width - 1];
    while (n > 9 && cp < lim) {
	next = n;
	n /= 10;
	*cp++ = (char) (next - n * 10 + '0');
    }
    if (cp < lim) {
	*cp++ = (char) (n + '0');
    }

    sp = s;
    if (minus) {
	*sp++ = '-';
    }

    while (cp > buf) {
	*sp++ = *--cp;
    }

    *sp++ = '\0';
    return s;
}
