#define __t__ TEMPLATE_IPMI_EVENTS
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
    <% _ipmi_enabled = 1; %>
#else
    <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

    COND_SHOW_BEGIN(!_ipmi_enabled)

	NOTICE_BEGIN(center)
        	A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
	NOTICE_END()

    COND_SHOW_END(!_ipmi_enabled)

    COND_SHOW_BEGIN(_ipmi_enabled)

	DIALOGTABLE_BEGIN()
	  <tr>
	    <td align="right" class="normal">Range</td>
	    <td colspan="2">
	      <select name="range">
               <option value="1d" <% if (_range =="1d") { write("selected"); } %>> A_("Last 24 hours")
               <option value="3d" <% if (_range =="3d") { write("selected"); } %>> A_("Last 3 days")
	       <option value="7d" <% if (_range =="7d") { write("selected"); } %>> A_("Last 7 days")
	       <option value="30d" <% if (_range =="30d") { write("selected"); } %>> A_("Last 30 days")
	       <option value="user" <% if (_range =="user") { write("selected"); } %>> A_("User specified")
	       <option value="all" <% if (_range =="all") { write("selected"); } %>> A_("All")
	      </select>
	       SUBMIT_BUTTON(T_("Update"), "update", "update", "")
	    </td>
	  </tr>
	  <tr>
           <td align="right" class="normal">A_("User specified range<br>(YYYY-MM-DD)")</td>
	    <td colspan="2">
	      <div class="normal">
                <input type="text" name="range_from" maxlength="10" size="13" value="<% writeEsc(range_from); %>">&nbsp;A_("to")&nbsp;
		<input type="text" name="range_to" maxlength="10" size="13" value="<% writeEsc(range_to); %>">
	      </div>
	    </td>
	  </tr>

	  COND_SHOW_BEGIN(_need_update == "yes" || _need_update == "")
	    <tr>
	      <td class="normal nowrap">A_("Current system time:")</td>
	      <td colspan="2" class="normal"><% write(ipmi_system_time); %></td>
	    </tr>
	    <tr>
	      <td class="bold nowrap">A_("Time")</td>
	      <td class="bold">A_("Sensor")</td>
	      <td class="bold">A_("Description")</td>
	    </tr>
	  COND_SHOW_END(_need_update == "yes" || _need_update == "")

	  <% if (_need_update == "yes" || _need_update == "") {
	       write('<tr><td align="center" colspan="3" class="bold nowrap">A_("Press update to show events!")</td></tr>');
	     } else if (event_time_cnt == 0) {
	       write('<tr><td align="center" colspan="3" class="bold nowrap">A_("No events logged.")</td></tr>');
	     } else {
		for (i = 0; i < event_time_cnt; i++) {
		  write('<tr><td class="normal nowrap">', htmlEsc(getVarByIdx("event_time", i)), '</td>\n',
			'<td class="normal nowrap">', htmlEsc(getVarByIdx("event_sensor", i)), '</td>\n',
			'<td class="normal">', htmlEsc(getVarByIdx("event_descr", i)), '</td></tr>\n');
		}
	     }
	   %>
 	   <tr><td align="center" colspan="3">
	       SUBMIT_BUTTON(T_("Clear Event Log"), "clear_event_log", "clear_event_log", "")
	   </td></tr>
	DIALOGTABLE_END()

    COND_SHOW_END(_ipmi_enabled)

TMPL_END()
