#define __t__ TEMPLATE_KM
TMPL_BEGIN()

<% show_usb = kmIsUsbSupported();
   show_ps2 = kmIsPS2Supported();
   _kvm_port_count = kvmGetUnitPortCount(__target_unit__);
%>

<script type="text/javascript">
  <!--
    function KmUpdateState() {
        COND_SHOW_BEGIN(_show_apply)
        var inputTypeElem       = getElement("name", FMS(FV_ID_KM_INPUT_TYPE), 0);
        var usbTypeElem         = getElement("name", FMS(FV_ID_KM_USB_TYPE), 0);
	var targetPortElem      = getElement("name", "__target_port__", 0);
	var kbdModelElem        = getElement("id", "kbd_model", 0);
	var mouseModeAutoElem   = getElement("id", "mouse_mode_auto", 0);
	var mouseModeDirectElem = getElement("id", "mouse_mode_direct", 0);
	var mouseScalingElem    = getElement("id", "mouse_scaling", 0);
	var activeMessageElem   = getElement("id", "km_active_message", 0);
	var updateUSBTypeElems = false;
	
#ifdef PP_FEAT_KBD_BREAK_TIMEOUT
	var kbdBrkTimeoutEnblElem = getElement("name", FMS(FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED), 0);
	var kbdBrkTimeoutMsecElem = getElement("name", FMS(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC), 0);

	kbdBrkTimeoutMsecElem.disabled = !kbdBrkTimeoutEnblElem.checked;
#endif	

	COND_SHOW_BEGIN(show_usb && show_ps2)
	if (inputTypeElem.value == "usb") {
	    activeMessageElem.style.display = "none";
	    usbTypeElem.disabled            = false;
	    kbdModelElem.disabled           = true;
	    updateUSBTypeElems              = true;
	} else if (inputTypeElem.value == "ps2") {
	    activeMessageElem.style.display = "none";
	    usbTypeElem.disabled            = true;
	    kbdModelElem.disabled           = false;
	    targetPortElem.disabled	    = false;
	    mouseModeAutoElem.disabled      = false;
	    mouseModeDirectElem.disabled    = false;
	    mouseScalingElem.disabled       = false;
	} else {
	    activeMessageElem.style.display = "";
	    usbTypeElem.disabled            = false;
	    kbdModelElem.disabled           = false;
	    targetPortElem.disabled	    = false;
	    mouseModeAutoElem.disabled      = false;
	    mouseModeDirectElem.disabled    = false;
	    mouseScalingElem.disabled       = false;
	}
	COND_SHOW_END(show_usb && show_ps2)

	COND_SHOW_BEGIN(!show_usb || !show_ps2)
	COND_SHOW_BEGIN(!show_usb)
	kbdModelElem.disabled         = false;
	targetPortElem.disabled	      = false;
	mouseModeAutoElem.disabled    = false;
	mouseModeDirectElem.disabled  = false;
	mouseScalingElem.disabled     = false;
	COND_SHOW_END(!show_usb)
	COND_SHOW_BEGIN(!show_ps2)
	targetPortElem.disabled	      = false;
	mouseModeAutoElem.disabled    = false;
	mouseModeDirectElem.disabled  = false;
	mouseScalingElem.disabled     = false;

	updateUSBTypeElems = true;
	COND_SHOW_END(!show_ps2)
	COND_SHOW_END(!show_usb || !show_ps2)

	if (updateUSBTypeElems) {
	    if (usbTypeElem.value == "absolute") {
		targetPortElem.disabled	     = true;
		mouseModeAutoElem.disabled   = true;
		mouseModeDirectElem.disabled = true;
		mouseScalingElem.disabled    = true;
	    } else {
		targetPortElem.disabled	     = false;
		mouseModeAutoElem.disabled   = false;
		mouseModeDirectElem.disabled = false;
		mouseScalingElem.disabled    = false;
	    }
	}

	var kmDirectMouseScaling = getElement("name", FMS(FV_ID_KM_DIRECT_MOUSE_SCALING), 0);

	kmDirectMouseScaling.disabled = mouseModeAutoElem.checked;

	COND_SHOW_END(_show_apply)
    }
    registerStateUpdater(KmUpdateState);
  -->
</script>

COND_SHOW_BEGIN(!show_usb)
  VARIABLE(FMS(FV_ID_KM_INPUT_TYPE), "ps2")
COND_SHOW_END(!show_usb)

VARIABLE(FMSZS(FV_ID_KM_KBD_MODEL), "<% write(_kvm_port_count); %>")
VARIABLE(FMSZS(FV_ID_KM_MOUSE_MODE), "<% write(_kvm_port_count); %>")
VARIABLE(FMSZS(FV_ID_KM_DIRECT_MOUSE_SCALING), "<% write(_kvm_port_count); %>")
VARIABLE(FMSZS(FV_ID_KM_GUD_MOUSE_EQZ), "<% write(_kvm_port_count); %>")
VARIABLE(FMSZS(FV_ID_KM_GUD_MOUSE_EQZ_PRESET), "<% write(_kvm_port_count); %>")
VARIABLE(FMSZS(FV_ID_KM_GUD_MOUSE_EQZ_ID), "<% write(_kvm_port_count); %>")

DIALOGTABLE_BEGIN()
  COND_SHOW_BEGIN(show_usb && show_ps2)
  <tr>
    <td class="settings_fieldname_en">A_("Host Interface")
      DIALOGTABLE_SPACER()
      <select <%isDisabled(FV_ID_KM_INPUT_TYPE);%> name=FMS(FV_ID_KM_INPUT_TYPE) onChange="KmUpdateState()">
        <option value="auto" <% if (FM(FV_ID_KM_INPUT_TYPE) == "auto") { write("selected"); } %>>A_("Auto")
        <option value="usb" <% if (FM(FV_ID_KM_INPUT_TYPE) == "usb") { write("selected"); } %>>A_("USB")
	<option value="ps2" <% if (FM(FV_ID_KM_INPUT_TYPE) == "ps2") { write("selected"); } %>>A_("PS/2")
      </select>
      <%isDefault(FV_ID_KM_INPUT_TYPE);%>
      <span id="km_active_message">
        <% if (FM(FV_ID_KM_INPUT_TYPE) == "auto") {
	if (kmIsUsbActive()) { write(T_("active: USB")); } else { write(T_("active: PS/2")); }
           }
        %>
      </span>
    </td>
  </tr>
  <tr>
    <td>
      DIALOGTABLE_SPACER()
      NOTICE_BEGIN()
	  A_("To use the <i>USB</i> and/or <i>PS/2</i> interface you need a correct cabling between the managed host and the managing device. If the managed host has no USB keyboard support in the BIOS and you have connected the USB cable only then you will have no remote keyboard access during the boot process of the host. If USB and PS/2 are both connected and you selected <i>Auto</i> as host interface then the card will choose USB if available or otherwise falls back to PS/2.")
      NOTICE_END()
    </td>
  </tr>
  COND_SHOW_END(show_usb && show_ps2)

  COND_SHOW_BEGIN(show_ps2)
  <tr>
    <td>&nbsp;</td>
  </tr>

  <tr>
    <td class="settings_fieldname_en">A_("PS/2 Keyboard Model")
      DIALOGTABLE_SPACER()
      <% _kbd_model = FM(FV_ID_KM_KBD_MODEL); %>
      <select <%isDisabled(FV_ID_KM_KBD_MODEL);%> id="kbd_model" name="<% write(FMS(FV_ID_KM_KBD_MODEL)); %>">
	<option value="pc104" <% if (_kbd_model == "pc104") { write("selected"); } %>> Generic 104-Key PC
	<option value="pc109" <% if (_kbd_model == "pc109") { write("selected"); } %>> Generic 109-Key PC
	<option value="mac"   <% if (_kbd_model == "mac")   { write("selected"); } %>> Apple Macintosh
      </select>
      <%isDefault(FV_ID_KM_KBD_MODEL);%>
    </td>
  </tr>
  COND_SHOW_END(show_ps2)

#if PP_FEAT_KBD_BREAK_TIMEOUT
  <tr>
    <td class="settings_fieldname">A_("Key release timeout")
      DIALOGTABLE_SPACER()
      <input <%isDisabled(FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED);%>
             type="checkbox" name=FMS(FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED) value="yes" onClick="KmUpdateState()"
	     <% if (FM(FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED) == "yes") { write("checked"); } %>>
	     A_("enabled")
      <%isDefault(FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("Timeout after")
	DIALOGTABLE_SPACER_PADDED()
	<select <%isDisabled(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC);%>
              name=FMS(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC)>
	<option value="25"  <% if (FM(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC) == "25")  { write("selected"); } %>> 25
	<option value="50"  <% if (FM(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC) == "50")  { write("selected"); } %>> 50
	<option value="100" <% if (FM(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC) == "100") { write("selected"); } %>> 100
	<option value="200" <% if (FM(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC) == "200" ||
                                   FM(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC) == "")    { write("selected"); } %>> 200
        </select> A_("msec")
      <%isDefault(FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC);%>
    </td>
  </tr>
  <tr>
    DIALOGTABLE_NEWCOL()
    <td class="settings_field">
      NOTICE_BEGIN()
        A_("Enable key release timeout if you experience duplicated keystrokes during poor network performance.")
      NOTICE_END()
    </td>
  </tr>
#endif /* PP_FEAT_KBD_BREAK_TIMEOUT */

  COND_SHOW_BEGIN(show_usb)
  <tr>
    <td class="settings_fieldname_en">A_("USB Mouse Type")
      DIALOGTABLE_SPACER()
      <select <%isDisabled(FV_ID_KM_USB_TYPE);%> name=FMS(FV_ID_KM_USB_TYPE) onChange="KmUpdateState()">
        <option value="relative" <% if (FM(FV_ID_KM_USB_TYPE) == "relative") { write("selected"); } %>> A_("Other Operating Systems")
        <option value="absolute" <% if (FM(FV_ID_KM_USB_TYPE) == "absolute") { write("selected"); } %>> A_("Windows &gt;= 2000, Mac OS X")
      </select>
      <%isDefault(FV_ID_KM_USB_TYPE);%>
    </td>
  </tr>
  COND_SHOW_END(show_usb)

  <tr>
    <td class="settings_fieldname">A_("Mouse speed")
      DIALOGTABLE_SPACER()
      <% _mouse_mode = FM(FV_ID_KM_MOUSE_MODE); %>
      <input <%isDisabled(FV_ID_KM_MOUSE_MODE);%> type="radio" id="mouse_mode_auto"
	     name="<% write(FMS(FV_ID_KM_MOUSE_MODE)); %>" value="auto"
             <% if (_mouse_mode == "auto" || _mouse_mode == "") { write("checked"); } %> onChange="KmUpdateState()"> A_("Auto")
      IS_DEFAULT_VALUE(FV_ID_KM_MOUSE_MODE, "auto")
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">
#if !defined(PP_FEAT_RARITAN_DESIGN)
     DIALOGTABLE_SPACER()
#endif		 
      <input <%isDisabled(FV_ID_KM_MOUSE_MODE);%> type="radio" id="mouse_mode_direct"
	     name="<% write(FMS(FV_ID_KM_MOUSE_MODE)); %>" value="direct"
    	     <% if (_mouse_mode == "direct") { write("checked"); } %> onChange="KmUpdateState()"> A_("Fixed scaling")
      IS_DEFAULT_VALUE(FV_ID_KM_MOUSE_MODE, "direct"):
      <% _mouse_scaling = FM(FV_ID_KM_DIRECT_MOUSE_SCALING); %>
      <select <%isDisabled(FV_ID_KM_DIRECT_MOUSE_SCALING);%> id="mouse_scaling"
	      name="<% write(FMS(FV_ID_KM_DIRECT_MOUSE_SCALING)); %>">
	<option value="0.25" <% if (_mouse_scaling == "0.25") { write("selected"); } %>> 0.25
	<option value="0.50" <% if (_mouse_scaling == "0.50") { write("selected"); } %>> 0.50
	<option value="1.00" <% if (_mouse_scaling == "1.00") { write("selected"); } %>> 1.00
	<option value="2.00" <% if (_mouse_scaling == "2.00") { write("selected"); } %>> 2.00
	<option value="4.00" <% if (_mouse_scaling == "4.00") { write("selected"); } %>> 4.00
      </select>
      <%isDefault(FV_ID_KM_DIRECT_MOUSE_SCALING);%>
    </td>
  </tr>

# ifdef PP_FEAT_MOUSE_G_UND_D
  <tr>
    <% _gud_mouse_eqz = FM(FV_ID_KM_GUD_MOUSE_EQZ); %>
    <td>
      DIALOGTABLE_SPACER()
      <input <%isDisabled(FV_ID_KM_GUD_MOUSE_EQZ);%> type="checkbox"
	     name=FMS(FV_ID_KM_GUD_MOUSE_EQZ) value="yes"
	     <% if (_gud_mouse_eqz == "yes") { write("checked"); } %> > A_("G&amp;D Equalizer")
      <%isDefault(FV_ID_KM_GUD_MOUSE_EQZ);%>
      &nbsp;&nbsp;&nbsp;
      <% _gud_mouse_preset = FM(FV_ID_KM_GUD_MOUSE_EQZ_PRESET); %>
      <select <%isDisabled(FV_ID_KM_GUD_MOUSE_EQZ_PRESET);%> name=FMS(FV_ID_KM_GUD_MOUSE_EQZ_PRESET)>
        <option value="0" <% if (_gud_mouse_eqz == "0") { write("selected"); } %>> A_("Auto")
	<option value="8" <% if (_gud_mouse_eqz == "8") { write("selected"); } %>> 8
	<option value="4" <% if (_gud_mouse_eqz == "4") { write("selected"); } %>> 4
	<option value="2" <% if (_gud_mouse_eqz == "2") { write("selected"); } %>> 2
	<option value="1" <% if (_gud_mouse_eqz == "1") { write("selected"); } %>> 1
      </select>
      <%isDefault(FV_ID_KM_GUD_MOUSE_EQZ_PRESET);%>
      <% if (_gud_mouse_eqz == "yes" && _gud_mouse_eqz == "0") { 
	  write(T_(" is: "));
	     _gud_mouse_eqz_id = FM(FV_ID_KM_GUD_MOUSE_EQZ_ID);
	     if (_gud_mouse_eqz_id != "") { write(_gud_mouse_eqz_id); } else { write(T_("n/a")); }
	     write(T_(" ticks/mm"));
	 }
      %>
    </td>
  </tr>
# endif /* PP_FEAT_MOUSE_G_UND_D */

#if defined(PP_FEAT_CAT)
  <tr>
    <td class="settings_fieldname">A_("CAT")
      DIALOGTABLE_SPACER()
      <input <%isDisabled(FV_ID_KM_CAT);%> type="checkbox"
	     name=FMS(FV_ID_KM_CAT) value="yes"
	     <% if (FM(FV_ID_KM_CAT) == "yes") { write("checked"); } %> >
      enable Cursor Action Tracking
      <%isDefault(FV_ID_KM_CAT);%>
      <img align=middle src="/cat_logo_small.gif" alt="CAT">
    </td>
  </tr>
#endif /* PP_FEAT_CAT */

DIALOGTABLE_END()

TMPL_END()
