#define __t__ TEMPLATE_KVM_PORT_LIST
TMPL_BEGIN()

#if defined(PRODUCT_XX01IP_ANY)
<script type="text/javascript">
  <!--
    var switch_colors = new Array();
    <%
      _cnt = kvmGetUnitPortCount(0);
      for (i = 0; i < _cnt; i++) {
	  if (kvmIsPortSwitchAllowed(i) == "yes") { 
	      write('switch_colors['+i+']="aclallowaccess";\n');
	  } else {
	      write('switch_colors['+i+']="acldenyaccess";\n');
	  }
      }
      kvmInitFormData();
    %>
    function SetCBoxColor(cboxname) {
        var cboxElem = getElement("name", cboxname, 0);
        cboxElem.className = switch_colors[cboxElem.value];
    }
  //-->
</script>
#endif

DIALOGTABLE_BEGIN()
<% _nr_channels = kvmGetChannelCount();
   for (c = 0; c < _nr_channels; c++) {
#ifdef PRODUCT_ICPMMD
       _label = _("Active Blade");
#else /* !PRODUCT_ICPMMD */
       if (_nr_channels == 1) {
	   _label = N_("Active Port");
       } else {
	   _label = N_("Active Port on Channel ") + (c + 1);
       }
#endif /* !PRODUCT_ICPMMD */
       write('<tr>\n');
       write('<td class="settings_fieldname">', T_(_label) ,'\n');
#if !defined (PP_FEAT_RARITAN_DESIGN)
       write('</td><td class="settings_field">\n');
#else
       write('<br>\n');
#endif       
       _port_count = kvmGetUnitPortCount(0);
       kvmGetCurrUnitAndPort(c, "_active_unit", "_active_port");
       if (_active_port < 0) _active_port = 0;
#if defined(PRODUCT_XX01IP_ANY) && !defined(PRODUCT_XX01IPTT_ANY)
       if (kvmIsPortSwitchAllowed(_active_port) == "yes") { _color = "aclallowaccess"; } 
       else { _color = "acldenyaccess"; } 
       write('<select name="kvm_active_port_' + c + '" class="' + _color + '" onChange="SetCBoxColor(\'kvm_active_port_KVM_CHANNEL\')">\n');
       for (p = 0; p < _port_count; p++) {
	   if (kvmIsPortSwitchAllowed(p) == "yes") { _color = "aclallowaccess"; }
	   else { _color = "acldenyaccess"; }
	   _name = FMIT(TEMPLATE_KVM, FV_ID_KVM_PORTNAME, p);
	   write('<option class="' + _color + '" value="' + p + '" ');
	   if (p == _active_port) { write('selected'); }
	   write('>');
	   if (_name != "") {
	       write(_name + '(' + kvmGetPortnameFromIndex(p) + ')');
	   } else {
	       write(kvmGetPortnameFromIndex(p));
	   }
	   write("\n");
       }
       write('</select>\n');
#else /* !PRODUCT_XX01IP_ANY */
       write('<select name="kvm_active_port_' + c + '">\n');
       for (p = 0; p < _port_count; p++) {
	   _name = FMIT(TEMPLATE_KVM, FV_ID_KVM_PORTNAME, p);
	   write('<option value="' + p + '" ');
	   if (p == _active_port) { write('selected'); }
	   write('>');
	   if (_name != "") { 
	       write(_name + '(' + kvmGetPortnameFromIndex(p) + ')');
	   } else {
	       write(kvmGetPortnameFromIndex(p));
	   }
	   write("\n");
       }
       write('</select>\n');
#endif /* !PRODUCT_XX01IP_ANY */
#if !defined (PP_FEAT_RARITAN_DESIGN)
       write('</td><td class="settings_field">\n');
#endif 
       _SUBMIT_BUTTON(T_("Switch"), "switch", "switch_" + c)
       write('</td></tr>\n');
   }
%>
DIALOGTABLE_END()

TMPL_END()
