#warning add "is default" asterisks!       <%isDefault();%>
#define __t__ TEMPLATE_KVM_POWER_CTRL
TMPL_BEGIN()

VARIABLE("__target_unit__", "<% write(__target_unit__); %>")
VARIABLE("__target_port__", "<% write(__target_port__); %>")

<% kvmPCInitFormVars(); %>

DIALOGTABLE_BEGIN()
  COND_SHOW_BEGIN(_kvm_pc_ps_tty0_port_cnt == 1 && _kvm_pc_ps_tty1_port_cnt == 1)
    <tr>
      <td>
        NOTICE_BEGIN(center)
        A_("Please select at least one power switch in serial settings!")
	NOTICE_END()
      </td>
    </tr>
  COND_SHOW_END(_kvm_pc_ps_tty0_port_cnt == 1 && _kvm_pc_ps_tty1_port_cnt == 1)
  COND_SHOW_BEGIN(_kvm_pc_ps_tty0_port_cnt >= 1 || _kvm_pc_ps_tty1_port_cnt >= 1)
    <tr>
      <td class="settings_fieldname_checkbox_en">
	<input type="radio" name="_kvm_pc_serial_port" value="0"
                  <% if (_kvm_pc_serial_port == "0") { write(' checked'); } 
	             if (_kvm_pc_ps_tty0_port_cnt < 1) { write(' disabled'); }%>>
       DIALOGTABLE_SPACER_OPTION()
       A_("Serial Port 1")</td>
       <td class="center bold"><% writeEsc(_kvm_pc_ps_tty0_name); %></td>
    </tr>

    COND_SHOW_BEGIN(_kvm_pc_ps_tty0_port_cnt > 0)

    COND_SHOW_BEGIN(_kvm_pc_ps_tty0_device_cnt > 1)
    <tr>
      DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname">A_("Power Switch Device:")
        DIALOGTABLE_SPACER()
        <select name="_kvm_pc_ps_tty0_device">
	  <% for (devid = 0; devid < _kvm_pc_ps_tty0_device_cnt; devid++) {
	         write('<option value="' + devid + '"');
		 if (devid == _kvm_pc_ps_tty0_device && _kvm_pc_serial_port == "0") { write(' selected'); }
		 write('>' + htmlEsc(getVarByIdx("_kvm_pc_ps_tty0_devices", devid, "webs")) + '\n');
	     }
	  %>
	</select>
      </td>
    </tr>
    COND_SHOW_END(_kvm_pc_ps_tty0_device_cnt > 1)
    COND_SHOW_BEGIN(_kvm_pc_ps_tty0_device_cnt <= 1)
      VARIABLE("_kvm_pc_ps_tty0_device", "0"); 
    COND_SHOW_END(_kvm_pc_ps_tty0_device_cnt <= 1)

    <tr>
      DIALOGTABLE_NEWCOL()   
      <td class="settings_fieldname">A_("Power Switch Port:")
        DIALOGTABLE_SPACER()
        <select name="_kvm_pc_ps_tty0_port">
          <% for (portid = 0; portid < _kvm_pc_ps_tty0_port_cnt; portid++) {
	         write('<option value="' + portid + '"');
		 if (portid == _kvm_pc_ps_tty0_port && _kvm_pc_serial_port == "0") { write(' selected'); }
		 write('>' + htmlEsc(getVarByIdx("_kvm_pc_ps_tty0_ports", portid, "webs")) + '\n');
	     }
	  %>
	</select>
      </td>
    </tr>
    COND_SHOW_END(power_port_tty0_cnt > 0)
    COND_SHOW_BEGIN(power_port_tty0_cnt == 0)
    <tr>
      DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname" colspan="2">A_("No Power Switch selected in Serial Settings!")</td>
    </tr>
    COND_SHOW_END(power_port_tty0_cnt == 0)

#if !defined(PRODUCT_XX01IP_ANY)
  <tr>
    <td class="settings_fieldname_checkbox_en">
      <input type="radio" name="_kvm_pc_serial_port" value="1"
	     <% if (_kvm_pc_serial_port == "1") { write(' checked'); } 
		if (_kvm_pc_ps_tty1_port_cnt < 1) { write(' disabled'); }%>>

       DIALOGTABLE_SPACER_OPTION()
       A_("Serial Port 2")</td>
    <td class="center bold"><% writeEsc(_kvm_pc_ps_tty1_name); %></td>
  </tr>

    COND_SHOW_BEGIN(_kvm_pc_ps_tty1_port_cnt > 0)

    COND_SHOW_BEGIN(_kvm_pc_ps_tty1_device_cnt > 1)
    <tr>
      DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname">A_("Power Switch Device:")
        DIALOGTABLE_SPACER()
        <select name="_kvm_pc_ps_tty1_device">
	  <% for (devid = 0; devid < _kvm_pc_ps_tty1_device_cnt; devid++) {
	         write('<option value="' + devid + '"');
		 if (devid == _kvm_pc_ps_tty1_device && _kvm_pc_serial_port == "1") { write(' selected'); }
		 write('>' + htmlEsc(getVarByIdx("_kvm_pc_ps_tty1_devices", devid, "webs")) + '\n');
	     }
	  %>
	</select>
      </td>
    </tr>
    COND_SHOW_END(_kvm_pc_ps_tty1_device_cnt > 1)
    COND_SHOW_BEGIN(_kvm_pc_ps_tty1_device_cnt <= 1)
      VARIABLE("_kvm_pc_ps_tty1_device", "0"); 
    COND_SHOW_END(_kvm_pc_ps_tty1_device_cnt <= 1)

    <tr>
      DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname">A_("Power Switch Port:")
        DIALOGTABLE_SPACER()
        <select name="_kvm_pc_ps_tty1_port">
          <% for (portid = 0; portid < _kvm_pc_ps_tty1_port_cnt; portid++) {
	         write('<option value="' + portid + '"');
		 if (portid == _kvm_pc_ps_tty1_port && _kvm_pc_serial_port == "1") { write(' selected'); }
		 write('>' + htmlEsc(getVarByIdx("_kvm_pc_ps_tty1_ports", portid, "webs")) + '\n');
	     }
	  %>
	</select>
      </td>
    </tr>
    COND_SHOW_END(power_port_tty1_cnt > 0)
    COND_SHOW_BEGIN(power_port_tty1_cnt == 0)
    <tr>
      DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname" colspan="2">A_("No Power Switch selected in Serial Settings!")</td>
    </tr>
    COND_SHOW_END(power_port_tty1_cnt == 0)
#endif

  COND_SHOW_END(power_port_tty0_cnt >= 1 || power_port_tty1_cnt >= 1)

  <tr>
    DIALOGTABLE_NEWCOL()
    <td class="buttons" colspan="2">
	SUBMIT_BUTTON(T_("Append"), "append", "port_append", "")
	SUBMIT_BUTTON(T_("Insert"), "insert", "port_insert", "")
	SUBMIT_BUTTON(T_("Delete"), "delete", "port_delete", "")
    </td>
  </tr> 
  <tr>
    <td class="setting_fieldname" valign="center">
	<% imgButton(T_("&uarr;"), "uparrow", "port_up", "no"); %>
        <% imgButton(T_("&darr;"), "downarrow", "port_down", "no"); %>
    </td>
    <td colspan="2" align="center">
      <select name="_kvm_pc_powerport" size="8">
	<% for (i = 0; i < _kvm_pc_powerports_cnt; i++) {
	       write('<option value="' + i + '"');
	       if (_kvm_pc_powerport == i) { write('selected'); }
	       write('>' +  htmlEsc(getVarByIdx("_kvm_pc_powerports", i, "webs")) + '\n');
	   }
	%>
      </select>
    </td>
  </tr>	   
#if !defined(PP_FEAT_RARITAN_DESIGN)
   <tr>
    <td class="normal center" colspan="3">
	<a href="/kvm.asp">A_("Back to KVM settings")</a>
    </td>
  </tr>
#endif      
DIALOGTABLE_END()

TMPL_END()
