#define __t__ TEMPLATE_POWER_CONTROL_IPMI
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
    <% _ipmi_enabled = 1; %>
#else
    <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

COND_SHOW_BEGIN(!_ipmi_enabled)
  NOTICE_BEGIN(center)
    A_("Power Control via IPMI is not enabled. You should check the ") IPMI_SETTINGS().
  NOTICE_END()
COND_SHOW_END(!_ipmi_enabled)

COND_SHOW_BEGIN(_ipmi_enabled)
DIALOGTABLE_BEGIN()
    <tr>
    <td class="center" colspan="2">

    COND_SHOW_BEGIN(!_show_ipmi_power_off_confirm && !_show_ipmi_reset_confirm)
      SMART_SUBMIT_BUTTON(T_("Power On"), "poweron", "ipmi_power_on", T_("Really Power On"), "r_poweron", "really_ipmi_power_on", _show_ipmi_power_on_confirm, "")
      COND_SHOW_BEGIN(_show_ipmi_power_on_confirm)
        SUBMIT_BUTTON(T_("Cancel"), "cancel", "cancel_ipmi_power_on", "")
      COND_SHOW_END(_show_ipmi_power_on_confirm)
    COND_SHOW_END(!_show_ipmi_power_off_confirm && !_show_ipmi_reset_confirm)

    COND_SHOW_BEGIN(!_show_ipmi_power_on_confirm && !_show_ipmi_reset_confirm)
      SMART_SUBMIT_BUTTON(T_("Power Off"), "poweroff", "ipmi_power_off", T_("Really Power Off"), "r_poweroff", "really_ipmi_power_off", _show_ipmi_power_off_confirm, "")
      COND_SHOW_BEGIN(_show_ipmi_power_off_confirm)
        SUBMIT_BUTTON(T_("Cancel"), "cancel", "cancel_ipmi_power_off", "")
      COND_SHOW_END(_show_ipmi_power_off_confirm)
    COND_SHOW_END(!_show_ipmi_power_on_confirm && !_show_ipmi_reset_confirm)

    COND_SHOW_BEGIN(!_show_ipmi_power_on_confirm && !_show_ipmi_power_off_confirm)
      SMART_SUBMIT_BUTTON(T_("Reset"), "reset", "ipmi_reset", T_("Really Reset"), "r_reset", "really_ipmi_reset", _show_ipmi_reset_confirm, "")
      COND_SHOW_BEGIN(_show_ipmi_reset_confirm)
        SUBMIT_BUTTON(T_("Cancel"), "cancel", "cancel_ipmi_reset", "")
      COND_SHOW_END(_show_ipmi_reset_confirm)
    COND_SHOW_END(!_show_ipmi_power_on_confirm && !_show_ipmi_power_off_confirm)
    </td>
  </tr>
DIALOGTABLE_END()
COND_SHOW_END(_ipmi_enabled)
TMPL_END()
