
#include <stdio.h>
#include <string.h>

#include "pp/SIO.h"
#include "pp/NetConn.h"
#include "pp/CSCConnect.h"
#include "pp/CmdLineParse.h"
#include "pp/SXDB_Parse.h"
#include "pp/OS_Port.h"

/*
#include "RDM.h"
#include "RDM_Database.h"
#include "RDM_Notify_Receiver.h"
Ws2_32.lib ddraw.lib dinput.lib dxguid.lib ..\..\openssl\out32\ssleay32.lib ..\..\openssl\out32\libeay32.lib Rasapi32.lib ..\..\common\T82Lib.lib
kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib ..\..\openssl\out32\ssleay32.lib ..\..\openssl\out32\libeay32.lib Ws2_32.lib
*/

char	*p;
char	cmd[1000];
char	token[1000];
FILE	*fpEventOut = stdout;

typedef void (*func)(void);

int	address;

CCSCConnect rdm;
CCSCConnect rdmEvent;

OS_EVENT event;			// Event tuserd to wake up

void Help()
{
	printf("-Main Menu------------------------------------------------------------\n");
	printf(" <> = Requred parameters [] = optional paramgers\n");
	printf(" Discover <ipAddress>   Does a CSC Discovery.\n");
	printf(" OpenRDM <ipAddress>    Makes a CSC Connection to RDM\n");
	printf(" OpenEvent              Connects to the TCP event stream. (Use OpenRDM first.)\n");
	printf(" Subscribe              Subscribes to all events. (Use OpenEvent first)\n");
	printf(" Notify                 Sends a notification\n");
	printf(" Close                  Closes all connections.\n");
	printf(" ListenUDP              Listens for UDP event messages.\n");
	printf(" Save <outfile>         Saves the RDM database to a file\n");
	printf(" rdm <infile> [outfile] Executes an RDM request from a file.\n");
	printf("                        Optionally saves the response in a file.\n");
	printf(" rdm <xml_request>      Executes an rdm request from the command line.\n");
}

int	ReadEventThread( void * param )
{
	char	*p;
	int		result;

	// Read the event

	do
	{
		result = rdmEvent.ReadMessage( &p, 2048 );

		if (result <0)
			break;

		fprintf(fpEventOut,p);
		fprintf(fpEventOut,"\n");

		delete p;

	} while (1);

	return 0;
}

int GetIPAddress()
{
	int		address;
	int		y;

	p = GetNextValue(p, &y);
	address = y;
	address <<= 8;

	p = GetNextValue(p, &y);
	address |= y;
	address <<= 8;

	p = GetNextValue(p, &y);
	address |= y;
	address <<= 8;

	p = GetNextValue(p, &y);
	address |= y;

	return address;
}

void Discover()
{
	char	*pCSC_Info;

	address = GetIPAddress();

	pCSC_Info = Query_CSC_Info( address, 0 ,0 );

	if (pCSC_Info == NULL)
		printf("Server not found at %08X\n",address);
	else
	{
		printf(pCSC_Info);
		printf("\n");
		delete pCSC_Info;
	}
}

void OpenRDM()
{
	char	*pCSC_Info = NULL;
	int		result;

	address = GetIPAddress();

	rdm.Disconnect();

	result = rdm.Connect( address, 0, NULL );

	if (result <0)
	{
		printf("Error from Connect %d\n",result);
		return;
	}

	pCSC_Info = rdm.GetCSCInfo(  );

	if (pCSC_Info == NULL)
	{
		printf("Error from GetCSCInfo\n");
		return;
	}

	delete pCSC_Info;

	result = rdm.StartNewCSCSession("RDM", "admin", "raritan", "SSL", "CSC");

	if (result <0)
	{
		printf("Error from StartNewCSCSession %d\n",result);
		return;
	}
}

void OpenRDMEvent()
{
	char	*pCSC_Info = NULL;
	int		result;
	char	*pGetID = "<Session><GetSessionID/></Session>";
	char	*pResponse;
	CSXDB_Parse	parser;
	char	*pSessionID;
	char	*pSessionKey;

	if (!rdm.IsConnected())
	{
		printf("Not connected to RDM, use OpenRDM command.\n");
		return;
	}

	rdmEvent.Disconnect();

	// Get the session ID for the current RDM session

	result = rdm.WriteMessage( pGetID );

	if (result <0)
	{
		printf("Send error %d\n",result);
		return;
	}

	// Receive the response

	result = rdm.ReadMessage( &pResponse );

	if (result < 0)
	{
		printf("Recieve error %d\n",result);
		return;
	}

	// Parse response for sessionID and sessionKey

	result = parser.Parse( pResponse, strlen(pResponse) );

	if (result <0)
	{
		printf("Error parsing GetSessionID %d\n",result);
		return;
	}

	pSessionID = parser.GetDataBase()->GetData("/Session/GetSessionID/SessionID");

	if (pSessionID == NULL)
	{
		printf("Error parsing GetSessionID %d\n",result);
		return;
	}

	pSessionKey = parser.GetDataBase()->GetData("/Session/GetSessionID/SessionKey");

	if (pSessionKey == NULL)
	{
		printf("Error parsing GetSessionKey %d\n",result);
		return;
	}

	// Connect to the RDMEvent protocol for this session

	result = rdmEvent.Connect( address, 0, NULL );

	if (result <0)
	{
		printf("Error from Connect %d\n",result);
		return;
	}

	pCSC_Info = rdmEvent.GetCSCInfo(  );

	if (pCSC_Info == NULL)
	{
		printf("Error from GetCSCInfo\n");
		return;
	}

	delete pCSC_Info;

	result = rdmEvent.StartReferralCSCSession("RDMEvent", pSessionID, pSessionKey, "SSL");

	if (result <0)
	{
		printf("Error from StartReferralCSCSession %d\n",result);
		return;
	}

	// Create a thread to read in the event data

	OS_CreateThread( (void *)ReadEventThread, OS_THREAD_NORMAL, &rdmEvent );
}

void Subscribe()
{
	char	*pResponse;

	static char * pSub = "<Notify>"
						"<Subscribe> <Select> /System/Device[1]/Port </Select> <Events> * </Events> <Time/> <SubscriptionID/> <NodeID/> <SendData/> </Subscribe> "
						"</Notify>";

	// Get the session ID for the current RDM session

	int result = rdm.WriteMessage( pSub );

	if (result <0)
	{
		printf("Error while sending Subscribe Command %d\n",result);
		return;
	}

	// Receive the response

	result = rdm.ReadMessage( &pResponse );
}

void Notify()
{
	char	*pResponse;

	static char * pNotify = "<Notify>"
						"<Notify> <ID> FG1 </ID> <Event> System_Startup </Event> <Data> Hello There !</Data> </Notify>"
						"</Notify>";

	// Get the session ID for the current RDM session

	int result = rdm.WriteMessage( pNotify );

	if (result <0)
	{
		printf("Error while sending Notify Command %d\n",result);
		return;
	}

	// Receive the response

	result = rdm.ReadMessage( &pResponse );
}

void Close()
{
	rdm.Disconnect();
	rdmEvent.Disconnect();
}

void Save()
{
	CSIO_FP		sio;
	char		request[] = "<Database><Get><Select>/</Select><Nodes>*</Nodes><SubNodes>*</SubNodes></Get></Database>";
	char		*pResponse;
	int			result;

	// Send the message

	result = rdm.WriteMessage( request );

	if (result <0)
	{
		printf("Send error %d\n",result);
		return;
	}

	// Receive the response

	result = rdm.ReadMessage( &pResponse );

	if (result < 0)
	{
		printf("Recieve error %d\n",result);
		return;
	}


	p = GetNextToken(p,token,100,0," ");

	result = sio.Open(token,"w");

	if (result != 0)
	{
		printf("Cannot open file '%s'\n",token);
		return;
	}

	sio.Write( pResponse, strlen(pResponse) );

	sio.Close();

	if (pResponse != NULL)
		delete pResponse;
}

void RDM()
{
	CSIO_DMEM	outSIO;
	CSIO_FP		outFP;
	CSIO_FP		inFP;
	char		*pRequest;
	char		*pResponse;
	int			length;

	int			result;

	if (!rdm.IsConnected())
	{
		printf("Not connected to RDM, use OpenRDM command.\n");
		return;
	}

	p = SkipDelimiters( p );

	if (*p == '<')
	{
		p = GetNextToken(p,token,1000,0,"");

		// Send the message

		result = rdm.WriteMessage( token );

		if (result <0)
		{
			printf("Send error %d\n",result);
			return;
		}

		// Receive the response

		result = rdm.ReadMessage( &pResponse );

		if (result < 0)
		{
			printf("Recieve error %d\n",result);
			return;
		}
	}
	else
	{
		p = GetNextToken(p,token,100,0," ");

		result = inFP.Open(token,"r");

		if (result != 0)
		{
			printf("Cannot open file '%s'\n",token);
			return;
		}

		inFP.Seek(0,SEEK_END);
		length = inFP.Tell();
		inFP.Seek(0,SEEK_SET);
		/* FIXME: who deletes this? */
		pRequest = new char[length+1];
		inFP.Read(pRequest,length);
		pRequest[length] = 0;

		// Send the message

		result = rdm.WriteMessage( pRequest );

		if (result <0)
		{
			printf("Send error %d\n",result);
			return;
		}

		// Receive the response

		result = rdm.ReadMessage( &pResponse );

		if (result < 0)
		{
			printf("Recieve error %d\n",result);
			return;
		}


		p = GetNextToken(p,token,1000,0," ");

		if (token[0] != 0)
		{
			result = outFP.Open(token,"r");

			if (result != 0)
			{
				printf("Cannot open file '%s'\n",token);
				return;
			}

			outFP.Write( pResponse, strlen(pResponse));
		}
	}

	if (pResponse != NULL)
	{
		printf(pResponse);
		printf("\n");
		delete pResponse;
	}
}

// Main Menu commands

TOKEN	mainMenuCmds[] =
{
	{ "DISCOVER",	(int) Discover },
	{ "OPENRDM",	(int) OpenRDM },
	{ "OPEN",		(int) OpenRDM },
	{ "SUBSCRIBE",	(int) Subscribe },
	{ "SUB",		(int) Subscribe },
	{ "NOTIFY",		(int) Notify },
	{ "OPENEVENT",	(int) OpenRDMEvent },
	{ "CLOSE",		(int) Close },
//	{ "LISTENUDP",	(int) ListenUDP },
	{ "SAVE",		(int) Save },
	{ "RDM",		(int) RDM },
	{ "HELP",		(int) Help },
	{ "?",			(int) Help },
	{ "X",			(int) 1 },
	{ "EXIT",		(int) 1 },

	{ NULL,			0		   }
};


int main(int argc, char * argv[])
{
	int			value;
	int			result;

	result = CNetConn_SSL::SSL_Library_Init(SSL2_TXT_RC4_128_WITH_MD5);

	printf("-RDM_Testv1----------------------------------Type HELP or ? for help--\n");

	// Main Menu

	while (1)
	{
		printf("> ");

		gets(cmd);

		p = GetNextToken(cmd,token,1000,1);

		if (token[0] == 0)
			continue;

		value = GetTokenValue(token, mainMenuCmds);

		if (value == TOKENNOTFOUND)
		{
			printf("Command %s unknown. Type ? for help.\n", token);
			continue;
		}

		if (value == 1)
			return 0;

		((func)value)();
	}

	return 0;
}
