/**	
 *	@file	CSCProtocol.h
 *	@brief	Common Socket Connection Class
 *
 *	CSC Accepts TCP conections on a single port, negotiates which protocol
 *  to use and then passes the protocol off to a protocol handler.
 *  CSC also handles UDP messages and handles them off to a UDP handler.
 *  The defautl UDP handler is the CSC_Discovery handler. Another is the
 *  CC UDP handler.
 */

#ifndef _CSC_h_
#define _CSC_h_

//#include	"OS_Port.h"
#include "pp/TCPListener.h"
#include "pp/UDPListener.h"
#include "pp/CSCInfo.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

class CCSCProtocol;
class CSessionManager;
class CNetConn_SSL_CTX;

/*----------------------------------------
 *	CNetConn Class
 *--------------------------------------*/

class CCSC : private CTCPListener, public CUDPListener, public CCSCInfo
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Initializes the network connections
	 *
	 *  @param	tcpPort			The tcpPort to use ( default = 5000 )
	 *  @param	udpPort			The udpPort to use ( default = 5000 )

	 */

	CCSC( CSessionManager *pSessionManager, int tcpPort = 5000, int udpPort = 5000 );
	virtual ~CCSC();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Initializes the network connections
	 *
	 *	@return					0 = no error
	 */

	int Initialize( );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Stops the connections
	 * 
	 *
	 */

	void Shutdown();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Stops the connections
	 * 
	 *
	 */

/*	inline
	void AddProtocol( CCSCProtocol * pProtocol )
	{
		cscInfo.AddProtocol( pProtocol );
	}*/

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Call back function. Called when a new tcp connection has
	 *  been accepted
	 * 
	 *  @see CTCPListener
	 * 
	 *  This function must be over ridden to accept TCP connections.
	 * 
	 * 	@param	s				The socket
	 *  @param	ipAddress		The client IP address
	 *  @param	tcpPort			The client TCP Port
	 */

	virtual void AcceptClientSocket( SOCKET s, int ipAddress, int tcpPort );


protected:
	CSessionManager *pSessionManager;	///< Access to the session manager
	CNetConn_SSL_CTX *pSSLCtx;			///< Context for our SSL connections
	CCSCProtocol  *	pFirst;				///< List of CSC protocol handlers

};

#endif // _CSC_h_


