/**	
 *	@file	NetConn_Socket.cpp
 *	@brief	CNetConn derived class for unencrypted socket communications
 * 
 * 	Implementation of the CNetConn_RC4 class.
 *	Communications channel through a clear text socket
 *
 */

#include "pp/NetConn_RC4.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

	// Timeout values (in milliseconds)

//#define NOTIMEOUT	// for debugging only

#define	MINUTES					60000
#define	SELECT_TIMEOUT			15000		// Must be evenly divisable by a thousand
#define	IO_TIMEOUT				4*MINUTES

#define	SIZE_ENCRYPT_BUFFER		32768		// Size of the encrytion buffer when using RC4 encryption

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	static data
 *--------------------------------------*/

extern DWORD			dataIn;			// # of bytes received
extern DWORD			dataOut;		// # of bytes sent

/*----------------------------------------
 *	CNetConn_RC4 Class
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/
/** Constructors **/

CNetConn_RC4::CNetConn_RC4() :
	CNetConn_Socket()
{
	pEncryptBuffer = new BYTE[SIZE_ENCRYPT_BUFFER];
}

CNetConn_RC4::CNetConn_RC4(SOCKET s) :
	CNetConn_Socket(s)
{
	pEncryptBuffer = new BYTE[ SIZE_ENCRYPT_BUFFER ];
}

CNetConn_RC4::~CNetConn_RC4()
{
	delete[] pEncryptBuffer;
}

/*  --------------------------------------------------------------------*/
/** See NetConn_RC4.h **/

void CNetConn_RC4::SetRC4WriteKey( RC4_KEY * pRC4Key )
{
	wrRC4Key = *pRC4Key;
}

/*  --------------------------------------------------------------------*/
/** See NetConn_RC4.h **/

void CNetConn_RC4::SetRC4ReadKey( RC4_KEY * pRC4Key )
{
	rdRC4Key = *pRC4Key;
}

/*  --------------------------------------------------------------------*/
/** See NetConn_Socket.h **/

BOOL CNetConn_RC4::Write(const void * _pData, int count)
{
	const BYTE		*	pData = (const BYTE *) _pData;
	BOOL			bResult = true;
	int				partialCount;


	while (count && running)
	{
		// Get next chunk of data

		partialCount = count;
		if (partialCount > SIZE_ENCRYPT_BUFFER)
			partialCount = SIZE_ENCRYPT_BUFFER;

		// Encrypt the data

		RC4( &wrRC4Key, partialCount, pData, pEncryptBuffer );

		// Send data

		bResult = CNetConn_Socket::Write(pEncryptBuffer,partialCount);
		if (!bResult)
			break;

		pData += partialCount;
		count -= partialCount;
	}

	return bResult;
}

/*  --------------------------------------------------------------------*/
/** See NetConn_Socket.h **/

BOOL CNetConn_RC4::Read(void * _pData, int count)
{
	BYTE		*	pData = (BYTE *) _pData;
	BOOL			bResult;

	bResult = CNetConn_Socket::Read(pData,count);

	if (bResult)
	{
		RC4( &rdRC4Key, count, pData, pData );
	}

	return bResult;
}

