/**	
 *	@file	NetConn_Base.h
 *	@brief	 Base class for all CNetConn
 *
 *	CNetConn is a virutal class that defines basic read/write communications
 *	channel. Derived classes can implement SSL, RC4 encrypted or just clear
 *	text communication channels.
 */

#ifndef _NetConn_Base_h_
#define _NetConn_Base_h_

#include	"pp/OS_Port.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn Class
 *--------------------------------------*/

class CNetConn
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Write data to the network connection
	 *
	 *	@param	pData			Ptr to the data to write
	 *	@param	count			# of bytes to write
	 *	@return					true = no errors, false = write failed
	 */

	virtual	BOOL Write( const void * pData, int count )		= 0;

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Read data from the network connection
	 *
	 *	@param	pData		  	Ptr to the buffer
	 *	@param	count			# of bytes to read
	 *	@return					true = no errors, false = read failed
	 */

	virtual	BOOL Read( void * pData, int count )		= 0;

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Stops the connection
	 * 
	 * 	Any Reads or Writes will be terminated and the connection closed
	 *
	 */

	virtual	void Shutdown()								= 0;

};

#endif // _NetConn_Base_h_

