/**	
 *	@file	NetConn_Socket.h
 *	@brief	CNetConn derived class for unencrypted socket communications
 *
 */

#ifndef _NetConn_Socket_h_
#define _NetConn_Socket_h_

#include	"pp/NetConn_Base.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn_Socket Class
 *--------------------------------------*/

class CNetConn_Socket : public CNetConn
{
public:

	CNetConn_Socket();
	CNetConn_Socket( SOCKET s );
	virtual ~CNetConn_Socket();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Opens a socket
	 * 
	 * 	The socket that is created is passed to SetSocket()
	 *
	 *	@param	ipAddress		IP address to connect to
	 *	@param	port			port to connect to
	 *	@return					posix error number
	 */

	int OpenSocket( int ipAddress, int port );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Closes the socket
	 *
	 */

	void CloseSocket( );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Functions to Get and Set the socket
	 * 
	 * 	The socket can be created and used outside of this object.
	 *  Use these functions to tell this object the socket to use or get the
	 *  socket that is in use.
	 *
	 */

	void SetSocket(SOCKET s);
	SOCKET GetSocket();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Write data to the network connection
	 *
	 *	@param	pData			Ptr to the data to write
	 *	@param	count			# of bytes to write
	 *	@return					true = no errors, false = write failed
	 */

	virtual	BOOL Write( const void * pData, int count );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Read data from the network connection
	 *
	 *	@param	pData		  	Ptr to the buffer
	 *	@param	count			# of bytes to read
	 *	@return					true = no errors, false = read failed
	 */

	virtual	BOOL Read( void * pData, int count );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Read data from the network connection
	 *
	 *	@param	timeout		  	Timeout period in seconds
	 *	@return					true = no errors, false = read failed
	 */

	BOOL Select ( int timeout );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Stops the connection
	 * 
	 * 	Any Reads or Writes will be terminated and the connection closed
	 *
	 */

	virtual	void Shutdown();

protected:
	
	SOCKET	ioSocket;					///< The socket to communicate over
	int		running;					///< != the connection is running, 0 = terminate
};

#endif // _NetConn_h_
