/**	
 *	@file	NetConn_UDP.h
 *	@brief	CNetConn derived class for unencrypted socket communications
 *
 */

#ifndef _NetConn_UDP_h_
#define _NetConn_UDP_h_

#include "pp/OS_Port.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn_Socket Class
 *--------------------------------------*/

class CNetConn_UDP
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	SSL_Accept does the server side SSL negociations
	 *
	 *	@param	ctx				The SSL_CTX container
	 *	@return					1 = accepted, 0 = not accepted, -1 = error
	 */

	CNetConn_UDP(int ipAddress, int port);
	virtual ~CNetConn_UDP();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Write data to the network connection
	 *
	 *	@param	pData			Ptr to the data to write
	 *	@param	count			# of bytes to write
	 *	@return					true = no errors, false = write failed
	 */

	int Write( const void * pData, int count );

protected:

	SOCKET				udpSocket;		// UDP Socket
	struct	sockaddr_in	socketAddress;	// UDP Address
};


#endif // _NetConn_UDP_h_

