/*--------------------------------------------------------------------------------

	OS_MFC.cpp

	Copyright (c) 2001, Raritan Computer, Inc.

	ClientLib OS porting layer
	Microsoft MFC implementation

--------------------------------------------------------------------------------*/

// Include MFC defines

#include	"stdafx.h"
#include	"afxmt.h"

#include	"OS_Port.h"


#ifdef OS_MFC
#ifdef _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif //_DEBUG
#else //OS_MFC
#ifdef DMALLOC
#include "dmalloc.h"
#endif //DMALLOC
#endif //OS_MFC
//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

static DWORD	instanceCount = 0;		// # of times we have been initialized

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//--------------------------------------------------------------------------------
//
	void
	OS_Startup
	(
	)
//
//	Called to initialize the OS porting layer.
//
//	Can be called more than once. Increments the instanceCount static.
//
//--------------------------------------------------------------------------------
{
}

//--------------------------------------------------------------------------------
//
	void
	OS_Shutdown
	(
	)
//
//	Called to cleanup after the OS porting layer. 
//
//	Can be called more than once.  Deccrements the instanceCount static. Only after
//	instanceCount goes to zero will the OS porting layer resource be freed.
//
//--------------------------------------------------------------------------------
{
}

//--------------------------------------------------------------------------------
//								Thread Function
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	OS_THREAD							// Returns NULL if creation fails
	OS_CreateThread
	(
		void *		pFunction,			// Ptr to the start of the thread
		DWORD		dwAttributes,		// Thread attributes (OS_THREAD_xxx)
		void *		pParam				// Use data passed to the thread function
	)
//
//	Creates a thread. pFunction is the starting address. pParam is passed as an
//	argument to the thread function. dwAttributes contains special thread creation
//	attributes.
//
//	MFC: All threads are of the CWinThread class.
//
//--------------------------------------------------------------------------------
{
	CWinThread	*pThread;

	// Create the thread

	pThread = AfxBeginThread( (AFX_THREADPROC) pFunction, pParam, THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED   );

	if (pThread != NULL)
	{
		pThread->m_bAutoDelete = 0;
		pThread->ResumeThread();
	}

	return (OS_THREAD) pThread;
}

//--------------------------------------------------------------------------------
//
	DWORD								// The return value of the thread
	OS_DeleteThread
	(
		OS_THREAD	hThread				// HANDLE to the thread
	)
//
//	Deletes the thread. The OS_THREAD handle will no longer be valid after this call.
//	If the thread is still running, this function will wait for it to complete.
//
//--------------------------------------------------------------------------------
{
	CWinThread	*pThread = (CWinThread *) hThread;
	DWORD		returnValue = 0;

	ASSERT( hThread != NULL );

	if (hThread != NULL)
	{
		if (pThread->m_hThread)
		{
			WaitForSingleObject( pThread->m_hThread, INFINITE );
			GetExitCodeThread( pThread->m_hThread, &returnValue );
		}
	
		delete pThread;
	}

	return returnValue;
}

//--------------------------------------------------------------------------------
//
	DWORD								// The return value of the thread
	OS_WaitForThread
	(
		OS_THREAD	hThread				// HANDLE to the thread
	)
//
//	Waits for a thread to complete.
//
//--------------------------------------------------------------------------------
{
	CWinThread	*pThread = (CWinThread *) hThread;
	DWORD		returnValue = 0;

	ASSERT( hThread != NULL );
	ASSERT( pThread->m_hThread != NULL );

	WaitForSingleObject( pThread->m_hThread, INFINITE );
	GetExitCodeThread( pThread->m_hThread, &returnValue );

	return returnValue;
}


//--------------------------------------------------------------------------------
//
	OS_THREAD							// The return value of the thread
	OS_GetCurrentThread
	(
	)
//
//	Get handler of current thread. 
//
//--------------------------------------------------------------------------------
{
	// not supported
	return NULL;
}


//--------------------------------------------------------------------------------
//
  int 
  OS_GetTimeStamp
  (
    char *buf, 
    const int limit_size
  )
//
//	Get handler of current thread. 
//
//--------------------------------------------------------------------------------
{
	CTime theTime;

	theTime = CTime::GetCurrentTime();
	CString s = theTime.Format( "[%B %d %H:%M:%S]" );
	strncpy(buf, LPCTSTR(s), limit_size);

	return strlen(buf);
}



//--------------------------------------------------------------------------------
//								Event Function
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	OS_EVENT							// Returns NULL if creation fails
	OS_CreateEvent
	(
		DWORD		dwAttributes		// Event attributes (OS_EVENT_xxx)
	)
//
//	Creates an event.
//
//	MFC: Events are created via CreateEvent
//
//--------------------------------------------------------------------------------
{
	HANDLE	hEvent;

	hEvent = CreateEvent( NULL, FALSE, FALSE, NULL );

	if (hEvent == INVALID_HANDLE_VALUE)
		hEvent = NULL;

	return (OS_EVENT) hEvent;
}

//--------------------------------------------------------------------------------
//
	void
	OS_DeleteEvent
	(
		OS_THREAD	hOSEvent			// HANDLE to the thread
	)
//
//	Deletes the Event.
//
//--------------------------------------------------------------------------------
{
	HANDLE	hEvent = (HANDLE) hOSEvent;

	ASSERT( hEvent != NULL );

	CloseHandle( hEvent );
}

//--------------------------------------------------------------------------------
//
	void
	OS_SetEvent
	(
		OS_THREAD	hOSEvent			// HANDLE to the thread
	)
//
//	Deletes the Event.
//
//--------------------------------------------------------------------------------
{
	HANDLE	hEvent = (HANDLE) hOSEvent;

	ASSERT( hEvent != NULL );

	SetEvent( hEvent );
}

//--------------------------------------------------------------------------------
//
	void
	OS_ResetEvent
	(
		OS_THREAD	hOSEvent			// HANDLE to the thread
	)
//
//	Deletes the Event.
//
//--------------------------------------------------------------------------------
{
	HANDLE	hEvent = (HANDLE) hOSEvent;

	ASSERT( hEvent != NULL );

	ResetEvent( hEvent );
}

//--------------------------------------------------------------------------------
//
	DWORD								// Returns 0 or OS_ERROR_TIMEOUT
	OS_WaitForEvent
	(
		OS_THREAD	hOSEvent,			// HANDLE to the thread
		DWORD		timeout				// # of ms to wait for event or OS_INFINITE
	)
//
//	Deletes the Event.
//
//	If the timeout time it reached before the event is set, then the 
//
//--------------------------------------------------------------------------------
{
	HANDLE	hEvent = (HANDLE) hOSEvent;
	DWORD	result;

	ASSERT( hEvent != NULL );

	if (timeout == OS_INFINITE)
		timeout = INFINITE;

	result = WaitForSingleObject( hEvent, timeout );

	return result == WAIT_TIMEOUT ? OS_ERROR_TIMEOUT : 0;
}

//--------------------------------------------------------------------------------
//
	void
	OS_Sleep
	(
		DWORD	ms						// # of ms to sleep
	)
//
//	Sleeps the calling thread for (ms) milli-seconds.
//
//--------------------------------------------------------------------------------
{
	Sleep( ms );
}

//--------------------------------------------------------------------------------
//							Critical Section Function
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	OS_CRITICAL_SECTION					// Returns NULL if creation fails
	OS_CreateCriticalSection
	(
		DWORD		dwAttributes		// Event attributes (OS_CRITICAL_SECTION_xxx)
	)
//
//	Creates a Critical Section.
//
//	MFC: Events are created via InitializeCriticalSection()
//
//--------------------------------------------------------------------------------
{
	CRITICAL_SECTION *pCS;

	pCS = (CRITICAL_SECTION *) malloc( sizeof( CRITICAL_SECTION ) );

	if (pCS != NULL)
	{
		InitializeCriticalSection( pCS );
	}

	return (OS_CRITICAL_SECTION) pCS;
}

//--------------------------------------------------------------------------------
//
	void
	OS_DeleteCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to delete
	)
//
//	Deletes a Critical Section.
//
//--------------------------------------------------------------------------------
{
	CRITICAL_SECTION *pCS = (CRITICAL_SECTION *) hCS;

	ASSERT( pCS != NULL );

	DeleteCriticalSection( pCS );

	free( pCS );
}

//--------------------------------------------------------------------------------
//
	void
	OS_EnterCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to enter
	)
//
//	Enters a critical section.
//
//--------------------------------------------------------------------------------
{
	CRITICAL_SECTION *pCS = (CRITICAL_SECTION *) hCS;

	ASSERT( pCS != NULL );

	EnterCriticalSection( pCS );
}

//--------------------------------------------------------------------------------
//
	void
	OS_LeaveCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to enter
	)
//
//	Enters a critical section.
//
//--------------------------------------------------------------------------------
{
	CRITICAL_SECTION *pCS = (CRITICAL_SECTION *) hCS;

	ASSERT( pCS != NULL );

	LeaveCriticalSection( pCS );
}

//--------------------------------------------------------------------------------
//								Misc. Function
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	DWORD
	OS_GetTickCount
	(
	)
//
//	Returns ms tick counter.
//
//--------------------------------------------------------------------------------
{
	return GetTickCount();
}

//--------------------------------------------------------------------------------

//

	int OS_GetLastSocketError

	(

	)

//

//	Returns 0.

//

//--------------------------------------------------------------------------------

{

	return 0;

}

