/*-------------------------------------------------------------------------------

	RDMP.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol class (CRDMP)

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	"pp/RDMP.h"
#include	"pp/RDM_Definitions.h"
#include	"pp/SXDB_Parse.h"
#include	"pp/Hash32.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDMP
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDMP::CRDMP
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	// Initialize data

	pServiceList			= NULL;

	cs = OS_CreateCriticalSection( OS_CRITICAL_SECTION_NORMAL );	
}

//--------------------------------------------------------------------------------
//
	CRDMP::~CRDMP
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	OS_DeleteCriticalSection( cs );
}

//--------------------------------------------------------------------------------
//
	int									// 0 or error code if request failed
	CRDMP::Command
	(
		CSession *	pUserSession,		// The user session or NULL for super user
		CSIO	*	pRequest,			// The request
		CSIO	*	pResponse			// The response -
										// Contains the return value on exit
	)
//
//	Processes an RDMP request and returns the response.
//
//	An error code is returned only if there was an I/O while writing to the
//	pResponse SIO or if there is a memory error.
//	All other errors are in the response sio. 
//
//------------------------------------------------------------------------------//
{
	CSXDB_Parse		parser;
	int			result,ioResult;
	int			hash = 0;
	const char		*pName = "";
	CSXDB_Node		*pNode;
	CSXDB_Node		*pIDNode;
	CRDM_Service	*pService;
	CSXDB			*pDB = NULL;

//	assert(pRequestDB != NULL);

	OS_EnterCriticalSection( cs );

	// Parse the request

	pRequest->Seek( 0, SEEK_SET );
	result = parser.ParseSIO( pRequest );

	// If there was a parse error, return an <RDMP> <Error> response

	if (result != 0)
		goto ERROR_EXIT;

	pDB = parser.GetDataBase();

	// Get the service name

	pNode = pDB->Root()->FindChildOfType( SXDB_TYPE_ELEMENT, NULL );

	if (pNode != NULL)
	{
		pName = pNode->GetName();
		hash = Hash32( 0, pName );
	}

	// Find matching service

	pService = this->pServiceList;

	while (pService)
	{
		if (hash == pService->hashCode)
		{
			if (strcmp(pName,pService->pName) == 0)
			{
				// Found the service
				
				// Output the service name in the response

				pResponse->Printf("<%s",pName);	// Service Name

				// Output request ID if found

				pIDNode = pNode->FindChildOfTypeByName( SXDB_TYPE_ATTRIBUTE, "id", NULL );

				if (pIDNode != NULL && pIDNode->GetData() != NULL)
					pResponse->Printf(" id=\"%s\"", pIDNode->GetData());

				pResponse->Putc('>');

				// Call the service

				result = pService->Command( pUserSession, pNode, pResponse );

				// Close the response (& check for IO errors)

				ioResult = pResponse->Printf("</%s>",pName);

				if (result != 0)
					result = RDM_ERROR_IO_ERROR;

				goto EXIT;
			}
		}

		pService = pService->pNext;
	}

	// Serivce not found, return error

	pResponse->Printf( "<%s><Error> %d </Error></%s>",pName,RDM_ERROR_SERVICE_NOT_FOUND,pName);

	goto EXIT;

	// Error, send RDM error message.

ERROR_EXIT:
	pResponse->Printf( "<RDM><Error> %d </Error></RDM>",result);

EXIT:
	
	OS_LeaveCriticalSection( cs );

	return result;
}

//--------------------------------------------------------------------------------
//
	void
	CRDMP::AddService
	(
		CRDM_Service *pService			// The service to add
	)
//
//	Adds a new service to RDMP
//
//------------------------------------------------------------------------------//
{
	OS_EnterCriticalSection( cs );

	pService->pNext = pServiceList;
	pServiceList = pService;

	OS_LeaveCriticalSection( cs );
}

//--------------------------------------------------------------------------------
//
	void
	CRDMP::RemoveService
	(
		CRDM_Service *pService			// The service to remove
	)
//
//	Removes a service
//
//------------------------------------------------------------------------------//
{
	CRDM_Service *pTemp;

	OS_EnterCriticalSection( cs );

	if (pServiceList == pService)
		pServiceList = pService->pNext;
	else
	{
		for (pTemp = pServiceList; pTemp != NULL && pTemp->pNext != pService; pTemp = pTemp->pNext)
			;

		if (pTemp != NULL)
			pTemp->pNext = pService->pNext;
	}

	pService->pNext = NULL;

	OS_LeaveCriticalSection( cs );
}

//--------------------------------------------------------------------------------
//
	CRDM_Service *						// NULL or ptr to the service object
	CRDMP::FindService
	(
		const char *	pServiceName			// Name of the service
	)
//
//	Removes a service
//
//------------------------------------------------------------------------------//
{
	CRDM_Service	*pService;
	int				hash;

	// Find matching service

	hash = Hash32( 0, pServiceName );
	pService = this->pServiceList;

	while (pService)
	{
		if (hash == pService->hashCode)
		{
			if (strcmp(pServiceName,pService->pName) == 0)
				break;
		}
		pService = pService->pNext;
	}

	return pService;
}

