/**	
 *	@file	RDM_DDA_Path.cpp
 *	@brief	Implementation of CDD_Path
 *
 *	Object that represents  .
 */

#include "pp/RDM_DDA_Path.h"
#include "pp/RDM_DDA_Port.h"
#include "pp/RDM_DDA_Utility.h"
#include "pp/SXDB_Parse_Table.h"
#include "assert.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Static Data
 *--------------------------------------*/

//----------------------------------------
//			Path Parse Table
//----------------------------------------

typedef struct
{
    const char    *pathID;                // kvm path id
    int     status;                 // Status attribute
    int     userPort;               // UserPort to which this device is conne
    int     localAccess;            //
    int     priorityMode;           //
    int     userType;
    int     portIndex;
} PATH_DATA;

#define PT_STRUCT   PATH_DATA
PT_BEGIN    ( "Path",            pathTable, PT_NO_UNKNOWN )
PT_ATT      ( "id",              pathID,           0,   PT_STRING_PTR )
PT_ATT      ( "Status",          status,        0,  PT_INT )
PT_ELEM     ( "UserPort",        userPort,      0,  PT_INT | PT_OPTIONAL )
PT_ELEM     ( "LocalAccess",     localAccess,   0,  PT_INT | PT_OPTIONAL )
PT_ELEM     ( "PriorityMode",    priorityMode,  0,  PT_INT | PT_OPTIONAL )
//PT_ELEM     ( "UserType",        userType,      0,  PT_INT | PT_OPTIONAL )
PT_ELEM     ( "PortIndex",        portIndex,    0,  PT_INT | PT_OPTIONAL )
PT_END
#undef  PT_STRUCT

/*----------------------------------------
 *	Device Class
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

CDDA_Path::CDDA_Path( CRDM * pNewRDM, CDDA_Port *pParentPort, const char *pID, int index ) :
	pRDM(pNewRDM)
{
	PATH_DATA   path;
	char		xPath[255];
	int			result;

	// Init data

	sendChgEvent		= 0;
	sendStatusEvent		= 0;
	okToSendEvents		= 0;
	strncpy(id,pID,RDM_MAX_ID-1);

	// Add Device node

	BeginUpdate();

	sprintf(xPath,"//*[@id=\"%s\"]",pParentPort->GetID());
    memset (&path, 0, sizeof (path));

    path.pathID = pID;          	      // path id
    path.status = 1;           		     // 1 indicates path available
    path.portIndex = index;

    result = SXDB_PT_Put(
                        pRDM->db, xPath,
                        PT_CHILD_APPEND,
                        pathTable,
                        &path,
                        0
                      );

	assert(result >= 0);

	EndUpdate();
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

CDDA_Path::~CDDA_Path( )
{
	// Delete our device node

	CSXDB_Node *p = pRDM->db->GetNodeFromID( id );
	if (p != NULL)
		delete p;
}


/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Path::BeginUpdate()
{
	pRDM->db->BeginAccess(1);
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Path::EndUpdate()
{
	pRDM->db->EndAccess();

	if (sendChgEvent && okToSendEvents)
	{
	}

	if (sendStatusEvent && okToSendEvents)
	{
	}

	sendChgEvent = sendStatusEvent = 0;
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Path::SetStatus( int status )
{
	char	statusText[2];

	statusText[0] = status + '0';
	statusText[1] = 0;

	CSXDB_Node *p = pRDM->db->GetNodeFromID( id );
	if (p != NULL)
	{
		pRDM->db->PutData("","Status",SXDB_TYPE_ATTRIBUTE,statusText,NULL,p);
	}

	sendStatusEvent = 1;
}


