/*-------------------------------------------------------------------------------

	RDM_Event_Protocol.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Event Protocol (CRDM_Event_Protocol)

	The notification reciever for RDM events passed to native RDM event protocol
	sockets.

--------------------------------------------------------------------------------*/

#define		DBTYPE		DBNET

#include <stdio.h>
#include <string.h>
#ifdef OS_POSIX
# include	<fcntl.h>
# include	<signal.h>
#endif

#include <openssl/rsa.h>       /* SSLeay stuff */
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rc4.h>
#include <openssl/evp.h>

#include <pp/syms.h>
#include <pp/OS_Port.h>
#include <pp/RDM_Event_Protocol.h>


//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDM_Event_Protocol
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDM_Event_Protocol::CRDM_Event_Protocol
	(
		void * s,
		CSession *pSession
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	socket = s;
	pUserSession = pSession;
	pSession->AddSessionObject( this );
	pSession->Event( pSession, SESSION_EVENT_CONNECT, (void*)"RDMEvent" );
}

//--------------------------------------------------------------------------------
//
	CRDM_Event_Protocol::~CRDM_Event_Protocol
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	pUserSession->RemoveSessionObject( this );
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Event_Protocol::Event
	(
		CSession	* pUserSession,		// The session in question...
		int			event,				// Which SESSION_EVENT_ code
		void		*pData				// Data associated with the event
	)
//
//	Handles session events.
//
//------------------------------------------------------------------------------//
{
	if (event == SESSION_EVENT_CLOSE ||
		(event == SESSION_EVENT_DISCONNECT && strcmp( (char *) pData,"RDM") == 0) )
	{
//OSDEP_		CloseNetConn( socket ); // Causes Process() to exit
		pUserSession->Event( pUserSession, SESSION_EVENT_DISCONNECT, (void*)"RDMEvent" );
	}
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Event_Protocol::Send
	(
		const char	*pEvent,				// The event message
		int		length					// strlen(pEvent)
	)
//
//	Send the event message text to it's destination.
//	Derive a new class from this base class and override this virtual method.
//
//------------------------------------------------------------------------------//
{
//OSDEP_	int		nLen = htonl(length+5);

//OSDEP_	WriteNetConnRaw( socket, (BYTE *) &nLen, 4 );
//OSDEP_	WriteNetConnRaw( socket, (BYTE *) pEvent, length+1 );
}
