/*-------------------------------------------------------------------------------

	RDM_Remote_Notify.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol Local Notification Subscription class (CRDM_Remote_Notify)

	This class is used to send notification to remotely connected clients.

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	"pp/RDM_Notify.h"
#include	"pp/RDM_Remote_Notify.h"
#include	"pp/SIO.h"
#include	"pp/RDM_Notify_Receiver.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDM_Remote_Notify
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDM_Remote_Notify::CRDM_Remote_Notify
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	CRDM_Remote_Notify::~CRDM_Remote_Notify
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Remote_Notify::Notify
	(
		RDM_EVENT	*pEvent				// The event
	)
//
//	Sends a notification to this subscription
//
//------------------------------------------------------------------------------//
{
	char					event[RDM_MAX_NOTIFICATION];
	CRDM_Notify_Receiver	*recv;
	int						length;

	RDM_ConvertEventToXML(	 pEvent,
							 event,
							 this->time,
							 this->nodeID,
							 this->serialNo,
							 this->sendData,
							 this->subID ? this->subscriptionID : -1,
							 this->deviceID
						 );

	length = strlen(event);

	// Send the message to the Notification Receivers.

	recv = NULL;

	while (( recv = (CRDM_Notify_Receiver *) this->pUserSession->EnumObjectByClass( RDM_NOTIFY_RECIEVER_CLASS, recv ) ))
	{
		recv->Send( event, length );
	}
}
