/*-------------------------------------------------------------------------------

	RDM_Service.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol service handler class (CRDM_Service)

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<pp/syms.h>
#include	<pp/RDM_Service.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDM_Service
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDM_Service::CRDM_Service
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	hashCode	= 0;
	pName		= NULL;
}

//--------------------------------------------------------------------------------
//
	CRDM_Service::~CRDM_Service
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	int							// 0 or error code if request failed
	CRDM_Service::Command
	(
		CSession	* NOTUSED(pUserSession),	// The user session or NULL for super user
		CSXDB_Node	* NOTUSED(pRootNode),		// Ptr to the root node of our functions
		CSIO		* NOTUSED(pResponse)		// The response -
								// Contains the return value on exit
	)
//
//	Processes an RDMP request and returns the response.
//
//------------------------------------------------------------------------------//
{
	return 0;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to the service name
	CRDM_Service::GetFirstFunction
	(
		CSXDB_Node	*pRootNode			// Ptr to the Service node
	)
//
//	Returns the ptr to the node of the first function
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*pNode;

	pNode = pRootNode->Child();

	if (pNode == NULL)
		return NULL;

	if (pNode->GetType() != SXDB_TYPE_ELEMENT)
		return GetNextFunction(pNode);

	return pNode;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to the service name
	CRDM_Service::GetNextFunction
	(
		CSXDB_Node	*pNode				// Ptr to the last function node
	)
//
//	Returns the ptr to the node of the next function
//
//------------------------------------------------------------------------------//
{
	do
	{
		pNode = pNode->Next();

		if (pNode == NULL)
			return NULL;

		if (pNode->GetType() == SXDB_TYPE_ELEMENT)
			break;
	} while (1);

	return pNode;
}

//--------------------------------------------------------------------------------
//
	int									// io result
	CRDM_Service::PrintError
	(
		CSIO	*pOut,
		int		error
	)
//
//	Prints an error to the output
//
//------------------------------------------------------------------------------//
{
	return pOut->Printf("<Error> %d </Error>",error);
}
