/*---------------------------------------------------------------------------

	RDM_BranchManager.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_BranchManager.cpp and the CRDM_BranchManager class
	
	// FIXME: i think this object contains some bloat, it should be just the interface

---------------------------------------------------------------------------*/

#ifndef _RDM_BranchManager_H_
#define	_RDM_BranchManager_H_

#include "pp/Session.h"
#include "pp/SXDB.h"
#include "pp/SXML.h"
#include "pp/RDM.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_BranchManager
{
public:

	CRDM_BranchManager() { };
	CRDM_BranchManager
	(
		class CRDM	*	pRDM,			// Ptr to the RDM object
		class CRDM_Database *pDBService = NULL // Ptr to the database serivce
											   // NULL = no add to DB service
	);

	virtual ~CRDM_BranchManager();

	virtual
	const char *								// Ptr to the service name
	GetName() {	return pName; }

	virtual
	int									// the hash code
	GetHashCode(){ return hashCode; }

	virtual
	int									// 0 or Error code
	Append
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The Node to be appended too
		CSXDB_Node	*pData			// Ptr to data to append
	);

	virtual
	int									// 0 or Error code
	Update
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The Node to be appended too
		CSXDB_Node	*pData			// Ptr to data to append
	);

	virtual
	int									// 0 or Error code
	Delete
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode			// The Node to be appended too
	);

	virtual
	int								// 0 = Not processed, 1 = processed, < 1 = error
	PreProcessDelete
	(
		CSession	*pUserSession,	// User session or NULL for super user
		const char		*pXPath,		// Ptr to the xpath
		CSIO		*pResponse		// SIO Response
	);

	// Power Related

	virtual
	int								// 0 or error code
	AssociateOutlet
	(
		const char	*port_id,			// The target that will be controlled
		const char	*outlet_id			// The outlet that controls it
	);

	virtual
	int								// 0 or error code
	SetPowerState
	(
		const char	*outlet_id,			// The outlet to set the power state for
		int		state				// 0 = cycle power, 1 = On, 2 = Off
	);

	virtual
	char *							// Ptr to the allocated power status string
	GetPowerStripStatus
	(
		const char	*strip_id			// The outlet strip to get the status for
	);

	// --------------------------------
	// Data
	// --------------------------------

public:

	class CRDM_BranchManager *	pNext;	// Ptr to next server in linked list

protected:

	class CRDM	*	pRDM;		// Ptr to the root RDM object
	int				hashCode;	// hash of service name for fast compare
	const char		*	pName;		// Name of this service

};

#endif // _RDM_BranchManager_H_

