/*---------------------------------------------------------------------------

	RDM_Database.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Service.cpp and the CRDM_Database class

---------------------------------------------------------------------------*/

#ifndef _RDM_Database_H_
#define	_RDM_Database_H_

#include "pp/Session.h"
#include "pp/RDM_Service.h"
#include "pp/RDM_Subscription.h"
#include "pp/RDM_BranchManager.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Database : public CRDM_Service
{
public:

	CRDM_Database
	(
		class CRDM	*	pRDM			// Ptr to the RDM object
	);

	~CRDM_Database();

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// User session
		CSXDB_Node	*	pRootNode,		// Ptr to root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	int								// I/O error on output
	Get
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Count
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Order
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Append
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Update
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Delete
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);
	
	virtual
	int								// I/O error on output
	GetUpdatedID
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);	

	CRDM_BranchManager	*			// BM ptr or NULL if none found
	FindBranchManager
	(
		CSession	*pUserSession,	// User session or NULL for super user
		CSXDB_Node	*pNode			// The node of the function
	);

	CRDM_BranchManager	*			// BM ptr or NULL if none found
	EnumBranchManager
	(
		const char		*pName,	// The BM name
		CRDM_BranchManager	*pLast	// NULL to find first,
									// otherwise last found to find next
	);

	void
	AddBranchManager
	(
		CRDM_BranchManager	*pBM		// Ptr to the Branch Manager to add
	);

	void
	RemoveBranchManager
	(
		CRDM_BranchManager	*pBM		// Ptr to the subscription to remove
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

//	char		*	pName;				// Name of the service
//	int				hashCode;			// Hash code of the name
	CRDM_BranchManager	*pBMList;		// Ptr to linked list of Branch Managers

	OS_CRITICAL_SECTION	cs;				// cs for accessing banchmanager list

	class CRDM	*	pRDM;				// Ptr to the RDM object
};

#endif // _RDM_Database_H_


