/*--------------------------------------------------------------------------------

	RDM_EventCode.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Definition of the CRDM_EventCode and RDM_EventCodeSet classes

--------------------------------------------------------------------------------*/

#ifndef _RDM_EventCode_H_
#define	_RDM_EventCode_H_

//----------------------------------------
//				Equates
//----------------------------------------

#define	RDM_EC_MAX				32		// Max size of an event name

	// Event ID Code Definitions

enum
{
	RDM_EC_Invalid						= 0,

	// Interface Events

	RDM_EC_Modem_Connect				= 1,
	RDM_EC_Modem_Disconnect				= 2,
	
	// Unlogged System Events

	RDM_EC_Heart_Beat					= 16,
	RDM_EC_Progress_Update				= 17,

	// System Events

	RDM_EC_System_Startup				= 32,
	RDM_EC_System_Shutdown				= 33,
	RDM_EC_System_Init_Error			= 34,
	RDM_EC_System_Fatal_Error			= 35,
	RDM_EC_System_Run_Error				= 36,
	RDM_EC_System_General				= 37,
	RDM_EC_System_Reset					= 38,

	RDM_EC_System_Factory_Reset			= 39,
    RDM_EC_System_Start_Management		= 40,
    RDM_EC_System_Stop_Management		= 41,
	RDM_EC_System_Ready					= 42,
	RDM_EC_System_Progress_Begin		= 43,
	RDM_EC_System_Progress_End          = 44,

	// Device Events

	RDM_EC_Device_Added					= 64,
	RDM_EC_Device_Changed				= 65,
	RDM_EC_Device_Deleted				= 66,
	RDM_EC_Device_Change_Request		= 67,
	RDM_EC_Device_Setting_Change		= 68,
	RDM_EC_Device_Setting_Change_Request= 69,
	RDM_EC_Device_Status_Changed        = 70,
	RDM_EC_Device_Key_Event             = 71,
	RDM_EC_Device_Hardware_Event		= 72,
	RDM_EC_Device_Update_Started		= 73,
	RDM_EC_Device_Update_Completed		= 74,
	RDM_EC_Device_Config_Backup			= 75,
	RDM_EC_Device_Config_Restore		= 76,
	RDM_EC_Device_PowerSupply_Status_Changed = 77,
	RDM_EC_Device_Reset					= 78,

	// Port Events
	
	RDM_EC_Port_Added					= 80,
	RDM_EC_Port_Changed					= 81,
	RDM_EC_Port_Deleted					= 82,
	RDM_EC_Port_Change_Request			= 83,
	RDM_EC_Port_Status_Changed			= 84,

	// User Events
	
	RDM_EC_User_Added					= 96,
	RDM_EC_User_Changed					= 97,
	RDM_EC_User_Deleted					= 98,
	RDM_EC_User_Change_Request			= 99,
	RDM_EC_User_Password_Changed		= 100,

	// Group Events
	
	RDM_EC_Group_Added					= 112,
	RDM_EC_Group_Changed				= 113,
	RDM_EC_Group_Deleted				= 114,
	RDM_EC_Group_Change_Request			= 115,

	// Access Events
	
	RDM_EC_Access_Login					= 128,
	RDM_EC_Access_Logout				= 129,
	RDM_EC_Access_Login_Failed			= 130,
	RDM_EC_Access_Connection_Lost		= 131,
	RDM_EC_Access_Connection_Timeout	= 132,
	RDM_EC_Access_Connection_Denied		= 133,
	RDM_EC_Access_Console_Login			= 134,
	RDM_EC_Access_Console_Logout		= 135,
	RDM_EC_Access_Wrong_IP				= 136,
	RDM_EC_Access_Port_Connect			= 137,
	RDM_EC_Access_Port_Disconnect		= 138,

    RDM_EC_Path_Added                   = 160,
    RDM_EC_Path_Changed                 = 161,
    RDM_EC_Path_Deleted                 = 162,
    RDM_EC_Path_Change_Request          = 163,
    RDM_EC_Path_Status_Changed          = 164,

	RDM_EC_MAX_CODE
};


#define	RDM_EC_MAX_ARRAY			((RDM_EC_MAX_CODE+31) / 32)	// # of 32-bit values needed to code all events

//----------------------------------------
//				Data Types
//----------------------------------------

typedef struct
{
	const char	*pName;						// Name of the event
	int		id;							// ID of the event
} RDM_EVENT_DEFINITION;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class CRDM_EventCode
//----------------------------------------

class	CRDM_EventCode
{
public:

	CRDM_EventCode
	(
		int		eventID					// The numeric event ID
	);

	CRDM_EventCode();

	~CRDM_EventCode();

	int									// 0 for failure, 1 for success
	Set
	(
		int		eventID					// The numeric event ID
	);

	int									// 0 for failure, 1 for success
	Set
	(
		const char *pEventName				// Ptr to the event name
	);

	int									// event ID
	GetID
	(
	);

	static
	int									// event ID
	GetIDByName
	(
		const char	*pEventName				// Ptr to the event name
	);
	
	static
	int									// event ID
	GetIDByWildCardName
	(
		const char	*pEventName,			// Ptr to the event name
		int		lastID					// id from last GetID or 0 for first search
	);

	const char *						// Ptr to the event name or NULL if
	GetName
	(
	);

	const char *						// Ptr to the event name or NULL if
	GetName
	(
		int		eventID					// Numeric ID of event
	);

	// --------------------------------
	// Data
	// --------------------------------

protected:

	int		index;						// Which 32 event code range
	int		mask;						// Mask of the specific event
	int		id;							// id of the event

	friend	class CRDM_EventCodeSet;
};

//----------------------------------------
//				Class CRDM_EventCodeSet
//----------------------------------------

class	CRDM_EventCodeSet
{
public:
	CRDM_EventCodeSet();
	~CRDM_EventCodeSet();

	int									// # of events added
	AddEvents
	(
		const char	* pEventNames			// Space or Comma separated event name list
										// each name can contain the * and ? wildcards
	);

	int									// # of events removed
	RemoveEvents
	(
		const char	* pEventNames			// Space or Comma separated event name list
										// each name can contain the * and ? wildcards
	);

	int									// # of events added
	AddEvent
	(
		CRDM_EventCode	*ec				// Event code to add to the set
	);

	int									// # of events added
	RemoveEvent
	(
		CRDM_EventCode	*ec				// Event code to remove from the set
	);

	int									// # of events added
	AddEvent
	(
		int		id						// Event id to add to the set
	);

	int									// # of events added
	RemoveEvent
	(
		int		id						// Event id to remove from the set
	);

	void
	ClearEvents
	(
	);

	int									// !0 if event is in the set
	IsEvent
	(
		CRDM_EventCode	*ec				// Ptr to the event code to test
	);

	int									// !0 if event is in the set
	IsEvent
	(
		int		eventID					// Numeric ID of the event
	);

	int									// !0 if event is in the set
	IsEvent
	(
		const char *	pEventName				// Ptr to the event name
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

	int		set[RDM_EC_MAX_ARRAY];		// The set

};

#endif // _RDM_EventCode_H_


