/*-------------------------------------------------------------------------------

	RDM_OS_Dependent.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Functions that RDM needs that are OS or Platform dependent.

--------------------------------------------------------------------------------*/

#ifndef _RDM_OS_Dependent_H_
#define	_RDM_OS_Dependent_H_

//----------------------------------------
//				Equates
//----------------------------------------

#define	MAX_RDM_TIME_STRING			20	// # of characters in an RDM Time string

//----------------------------------------
//				Data Types
//----------------------------------------

#pragma pack(1)
typedef struct
{
	WORD	year;
	BYTE	month;
	BYTE	day;
	BYTE	hour;
	BYTE	minute;
	BYTE	second;
} RDM_TIME;
#pragma pack()

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	char *								// Ptr to the string
	RDM_RDMTimeToString
	(
		RDM_TIME	*pST,				// Ptr to the SYSTEMTIME struct
		char		*pString			// Where to put the string
	);

	void
	RDM_GetSystemTime
	(
		RDM_TIME	*pRDMTime
	);

	int									// RDM_ERROR
	RDM_SetSystemTime
	(
		RDM_TIME	*pRDMTime
	);

	int									// RDM_ERROR
	RDM_ConvertUTCToLocalTime
	(
		RDM_TIME	*pUTCTime,
		RDM_TIME	*pLocalTime
	);

	CSXDB_Node	*					// Ptr to DeviceSettings
	RDM_GetDeviceSettings
	(
	);

	int									// RDM_ERROR
	RDM_CommitDeviceSetting
	(
	);

	int									// RDM_ERROR
	RDM_ShutDown
	(
	);

	int									// RDM_ERROR
	RDM_Restart
	(
	);

	int									// RDM_ERROR
	RDM_CloseAllVideoStreams
	(
	);

    char *
    RDM_CreateUniqueID
    (
        const char    *pPrefix,
        int     num,
        char    *pOutput
    );

    const char *						// Returns ptr to deviceID string or NULL if none
    RDM_GetDeviceID
    (
    );

    /** 
     * @brief Obtains the MAC address of the ethernet based on the ethernet interface
     *        name. 
     *
     * @param  ifName      - The interface name to get the MAC address.
     * @param  MACAddress  - user supplied array of characters to be filled with the
     *                       MAC address.
     *
     */ 
    void
    RDM_GetMACAddress
    ( 
	const char *ifName,
	char * MACAddress
    ); 

//----------------------------------------
//				Static Data
//----------------------------------------

#endif	// _RDM_OS_Dependent_H_
