/*--------------------------------------------------------------------------------

	RDM_Subscription.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Subscription.cpp and the CRDM_Subscription class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Subscription_H_
#define	_RDM_Subscription_H_

#include "pp/Session.h"
#include "pp/SXDB.h"
#include "pp/SXML.h"
#include "pp/RDM_EventCode.h"
#include "pp/RDM_Definitions.h"
#include "pp/RDM_EventRecord.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

typedef struct
{
	char		ID[RDM_MAX_ID];			// The ID to match
	int			hash;					// Hash code for the ID
} RDM_HASHED_ID;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Subscription : public CRDM_EventCodeSet
{
public:

	CRDM_Subscription();

	virtual
	~CRDM_Subscription();

	int									// 0 = success
	SetSubscription
	(
		const char	*	pIDList,			// Space or Comma separated ID list
		const char	*	pEventList			// Space or Comma separated event list
	);

	int									// 0 = success
	Allocate
	(
		int		count					// # of ID spaces to create
	);

	int									// 0 = success
	SetID
	(
		int		index,					// Which ID to set
		const char	*pID					// The ID String
	);

	int									// !0 = notification match
	Test
	(
		const char	*	pID,				// Ptr to the ID string
		int			hash,				// Hash code of string
		int			eventID				// Numeric event ID
	);

	virtual
	void
	Notify
	(
		RDM_EVENT	*pEvent				// The event
	);

	inline
	void
	SetSubID
	(
		int		id						// The subscription ID
	)
	{
		subscriptionID = id;
	}

	inline
	int
	GetSubID
	(
	)
	{
		return subscriptionID;
	}

	inline
	void
	SetUser
	(
		CSession *	_pUserSession		// The user session or NULL for super user
	)
	{
		this->pUserSession = _pUserSession;
	}

	inline
	CSession *
	GetUser
	(
	)
	{
		return pUserSession;
	}

	// --------------------------------
	// Data
	// --------------------------------

protected:

	CSession	*	pUserSession;		// The user that created this session
	RDM_HASHED_ID	* pIDList;			// Ptr to an array of hashed IDs
	int				idCount;			// # of IDs in the list
	int				idAllocated;		// # of IDs allocated
	int				subscriptionID;		// The ID for this subscription

	class CRDM_Subscription *	pNext;	// Ptr to the next subscription in the linked list
	class CRDM_Notify	* pNotifyObject;// Ptr to the object we are subscribed to

	friend class CRDM_Notify;
};

#endif // _RDM_Subscription_H_


