/*-------------------------------------------------------------------------------

	SysProgressMgr.h

	Copyright (c) 2003, Raritan Computer, Inc.

	System progress manager class (CSysProgressMgr)

	This class is used by other components to report begin of progress,
	and end of progress. If first begin report comes, it will notify
	System_Progress_Begin event (event-43). If last end report comes, it will
	notify System_Progress_End (event-44). So that event-43 and event-44 can 
	be sent in serial order.  

--------------------------------------------------------------------------------*/

#ifndef _Sys_Progress_Mgr_H_
#define	_Sys_Progress_Mgr_H_

#include "pp/OS_Port.h"

//----------------------------------------
//				Equates
//----------------------------------------

#define MAX_LEN_PROGRESS_ID 24

#define MAX_LEN_PROGRESS_MSG 256 

//----------------------------------------
//				Data Types
//----------------------------------------
 
//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CSysProgressObj
{
public:

    CSysProgressObj
    (
        int type,           // 1 - database update; 2 - firmware update
        const char *id,           // must be unique. 
        const char *message=NULL
    );
    
    ~CSysProgressObj();

    int                     // 1 -- match; 0 -- no match 
    IfMatch
    (
        const char *id            // progress id
    );

    int m_type;
    char m_id[MAX_LEN_PROGRESS_ID];
    char m_message[MAX_LEN_PROGRESS_MSG];
    
    CSysProgressObj *m_next;    
};


class	CSysProgressMgr
{
public:

	CSysProgressMgr
	(
	    CRDM    *pRDM
	);
	
	~CSysProgressMgr
	(
	);

    void 
	ClearList
	(
	);
	
	void Lock();
	void Unlock();
	
	int                     // 1 -- yes, 0 -- no
	IfSysInProgress
	(
	);

    CSysProgressObj *
    GetSysProgressObj
    (
        const char *id            // progress id
    );

    int                     // 1 -- success, 0 -- fail
    InsertSysProgressObj
    (
       CSysProgressObj *obj 
    );
    
    int                     // 1 -- success, 0 -- fail
    RemoveSysProgressObj
    (
        const char *id
    );
	
	void
	ReportProgressBegin
	(
	    int type, 
	    const char *id, 
	    const char *message=NULL
	);
	
	void
	ReportProgressEnd
	(
	    const char *id 
	);
	
private:

    CSysProgressObj *m_list;    // head of list
    
    OS_CRITICAL_SECTION m_cs;
    
    CRDM    *m_pRDM; 

};


CSysProgressMgr *GetInstanceCSysProgressMgr();

#endif // _Sys_Progress_Mgr_H_
