/*--------------------------------------------------------------

CUserObject is a base class with set of virtual function.

User data structure varies from product to product.

Each product creates userobject by deriving from this base class
and implement the functionaly required.

--------------------------------------------------------------*/

#ifndef _UserObject_h_
#define _UserObject_h_

// User Object Types
// Values returned from GetUserObjectType()

enum
{
	UO_TYPE_BASE,
	UO_TYPE_TR,
	UO_TYPE_CC
};

// Values returned from GetPermission and GetNodePermission

enum {
    TR_PERM_NONE = 0,
    TR_PERM_READONLY,
    TR_PERM_READWRITE
};

// Values returned from GetAuthentication Type

enum {
    TR_LOCAL_AUTHENTICATED = 0,
    TR_LDAP_AUTHENTICATED,
    TR_RADIUS_AUTHENTICATED,
	TR_CC_AUTHENTICATED
};

// Base Class

class CUserObject
{
    public:
	virtual CUserObject* Clone() { return NULL; }; 
    		
	virtual	DWORD GetUserObjectType() = 0;

	virtual BOOL IsAdministrator () = 0;

        virtual BOOL IsDiagnosticEnabled () = 0;

	virtual const char* GetUserName () = 0;

	virtual const char* GetUserID () = 0;

	virtual const char* GetGroupName () = 0;

	virtual const char* GetGroupID () = 0;

	virtual DWORD GetPermission ( const char *SecurityId, const char *uniqueId ) = 0;

	virtual DWORD GetNodePermission ( const char *SecurityId ) = 0;

	virtual DWORD GetAuthentication() = 0;

	virtual BOOL AllowConcurrentAccess () = 0;

	virtual BOOL IsInterfaceEnabled ( const char * InterfaceName ) = 0;

	virtual const char* GetDialbackNumber () = 0;

	virtual BOOL IsPasswordExpired () = 0;

	virtual BOOL operator=( const CUserObject *pUserObject) = 0;

        virtual DWORD GetUserMenuAccessPermission () = 0;
};


#endif // #ifndef _UserObject_h_

