/**	
 *  @file	RFPDef.h
 *  @brief	Common Definitions for RFP Code
 * 
 *	
 */

#ifndef _RFPDef_h_
#define _RFPDef_h_

namespace pp
{

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

#define	RFP_MAX_FILES			64		// Max # of files in a package

/** Max lengths of string fields */

#define	RFP_MAX_TITLE			80		// Max <Title> length
#define	RFP_MAX_DESCRIPTION		160		// Max <Description> length
#define	RFP_MAX_COPYRIGHT		80		// Max <CopyRight> length
#define	RFP_MAX_PUBLISHER		80		// Max <Publisher> length
#define	RFP_MAX_FILENAME		256		// Max <FileName> or <MetaFileName> length
#define	RFP_MAX_SCRIPT			16		// Max <Script> length
#define	RFP_MAX_MODEL			32		// Max <Model> length
#define	RFP_MAX_COMPONENT		32		// Max <Component> length
#define	RFP_MAX_VERSION			32		// Max <Version> length
#define	RFP_MAX_VERSIONMIN		32		// Max <VersionMin> length
#define	RFP_MAX_VERSIONMAX		32		// Max <VersionMax> length
#define	RFP_MAX_SIGNATURE		400		// Max langth of a signature
#define RFP_MAX_SUPPORTED_DENSITY   256 // Max <SupportedDensity> length
#define RFP_MAX_SUPPORTED_HARDWARE  256 // Max <SupportedHardware> length

/** Constraints on the size of the file structures */

#define	RFP_MAX_HEADER_SIZE		65536	// Max size of the XML header
#define	RFP_MAX_SIGNATURE_SIZE	300		// Max size of a signature

#define RFP_ERROR_BASE      (0x02002000)// TRSP Error code base

/** RFP Error Codes */

// Possible result (or error) codes that an RFP update might encounter
enum
{
	RFP_OK = 0,						// No Error
    RFP_UPDATE_SUCCESS = 0,         // RFP update was successful
    RFP_ERROR_CHECKSUM = 1,         // RFP file checksum did not check out
    RFP_ERROR_FILE_FORMAT = 2,      // RFP file format error
    RFP_ERROR_DISK_MOUNT = 3,       // non-volatile storage could not be mounted
    RFP_ERROR_DISK_UNMOUNT = 4,     // non-volatile storage could not be umounted
    RFP_ERROR_FILE_WRITE = 5,       // manipulating files between mount and umount
                                    // failed, but reverted back to original state
    RFP_ERROR_PARTIAL_WRITE = 6,    // manipulating files between mount and umount
                                    // failed, and could not revert back originals
    RFP_ERROR_MODEL_MISMATCH = 7,   // RFP update was not for the target's model
    RFP_ERROR_VERSION_MISMATCH = 8, // RFP update was not for the target's version
    RFP_ERROR_TIMEOUT = 9,          // Client side timed out waiting for TRServer
    RFP_ERROR_CANCEL = 10,          // Client side sent cancel command
    RFP_ERROR_REQUEST_FORMAT = 11,  // RFP request format error
    RFP_ERROR_FILE_NOT_FOUND = 12,  // requested file not found
    RFP_ERROR_INTERNAL = 13,        // RFP internal error

    // Error codes relating to MPUpdate and local RDM access
    RFP_ERROR_XML_PARSE            = 14, // Could not parse the XML response 
    RFP_ERROR_PMCORE_STARTSERIAL   = 15, // Could not start serial communication
    RFP_ERROR_LOCAL_RDM_SYNTAX     = 16, // Wrong syntax for local RDM access utility
    RFP_ERROR_LOCAL_FILE_OPEN      = 17, // Could not open RDM command file
    RFP_ERROR_LOCAL_FILE_ACCESS    = 18, // Could not read/write RDM command file
    RFP_ERROR_LOCAL_SOCKET_OPEN    = 19, // Could not open local rdmp socket
    RFP_ERROR_LOCAL_SOCKET_CONNECT = 20, // Could not connect to local rdmp socket
    RFP_ERROR_LOCAL_SOCKET_WRITE   = 21, // Could not write to local rdmp socket
    RFP_ERROR_LOCAL_SOCKET_READ    = 22, // Could not read from local rdmp socket
    RFP_ERROR_STOP_SERVER          = 23, // Could not stop video/serial communication

    // per-packet ACK for RFP update
    RFP_PACKET_ACK                 = 24, // Acknowledgement for each data packet 
    RFP_AUTO_REBOOT                = 25, // Final result successful acknowledgement, but the unit is rebooting

    RFP_ERROR_NOT_COMPATIBLE_DENSITY  =26,  // Density Check Failed
    RFP_ERROR_NOT_COMPATIBLE_HARDWARE = 27, // Hardware check Failed
    RFP_ERROR_MISSING_DENSITY_TAG  =28,  // Density tag not found
    RFP_ERROR_MISSING_HARDWARE_TAG = 29, // Hardware tag not found
    RFP_ERROR_NOT_COMPATIBLE = 30,       // legacy RFP file not compatible

	RFP_ERROR_BAD_SCRIPT = 31,			// Script file could not be executed

    // MPupdate specific error codes only
    RFP_ERROR_FLASH_ERASE = 4000,
    RFP_ERROR_FLASH_PROGRAM = 4001,
    RFP_ERROR_FLASH_BLOCKCHECK = 4002,
    RFP_ERROR_FLASH_NORESPONSE = 4003,

	// RFPPack Errors

	RFP_ERROR_MEMORY				= 100,// Memory alloc error
	RFP_ERROR_TOO_MANY_FILES		= 101,// Too many files found in the header
	RFP_ERROR_NO_FILES 				= 102,// No files in the RFP
	RFP_ERROR_RSA_KEY_BAD 			= 103,// File does not contains a public key
	RFP_ERROR_BAD_SIGNATURE 		= 104,// A signature does not match the data
	RFP_ERROR_CANNOT_READ_FILE 		= 105,// A file could not be read
	RFP_ERROR_CANNOT_WRITE_FILE 	= 106,// A file could not be written
	RFP_ERROR_MAXLENGTH_NOT_LAST 	= 107,// <MaxLength> tag used BEFORE last file in rfp (no no)
	RFP_ERROR_MAXLENGTH_AND_LENGTH 	= 108,// <MaxLength> and <Length> both specified
	RFP_ERROR_PUBLIC_KEY_MISSING 	= 109,// A signature is needed, but no RSA file specified
	RFP_ERROR_RSA_KEY_MISSING 		= 110,// A signature is needed, but no RSA file specified
	RFP_ERROR_RC4_KEY_MISSING 		= 111,// Encryption is needed, but no RC4 key file specified
	RFP_ERROR_INTERNAL_ERROR 		= 112,// Bad stuff
	RFP_ERROR_BAD_METAFILE			= 113,// Metafile cannot be resolved.
	RFP_ERROR_NO_LENGTH				= 114,// No <Length> or <MaxLength> tags were specified

	// Special Return values for RFP Processing

	RFP_SKIP_FILE					= 1000,// Returned from function to indicate the current file should be skipped
};

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

} // namespace

#endif	// _RFPDef_h_



