/*--------------------------------------------------------------------------------

	RFPParse.cpp

	Copyright (c) 2002, Raritan Computer, Inc.

	Parser for RFP File Headers.
	This parser is based on the SXML XML parser class.

--------------------------------------------------------------------------------*/

#ifndef		_RFPParse_h_
#define		_RFPParse_h_

#include	"pp/SIO.h"
#include	"pp/SXML.h"
#include	"pp/RFPDef.h"
#include	<openssl/pem.h>

namespace pp
{

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

/** Structure the holds information about an individual RFP_File */

typedef struct
{
	char	sourceFile[RFP_MAX_FILENAME];		// Holds the <SourceFile> data (Only for RFP file creation)
	char	fileName[RFP_MAX_FILENAME];			// Holds the <FileName> string (isMetaFile = 0)
	char	metaFileName[RFP_MAX_FILENAME];		// Holds the <MetaFileName> string (isMetaFile = !0)
	char	resolvedFileName[RFP_MAX_FILENAME];	// Holds the REAL file name (fileName, sourceFile or resolved metafile)
	int		isMetaFile;							// !0 if the filename is a meta file name
	int		lengthSpecified;					// !0 if <Length> was found even if it is zero
	int		length;								// Length of the file or 0 if <MaxLength> used
	int		maxLength;							// MaxLength of the file or 0 if <Length used
	int		isScript;							// !0 if file is a script
	int		isMemoryFile;						// <MemoryFile> tag found
	char	script[RFP_MAX_SCRIPT];				// Holds the <Script> data (the name of the interpreter)
	int		isSigned;							// !0 if the file is signed
	char	signature[RFP_MAX_SIGNATURE];		// The Signature data
	int		isEncrypted;						// !0 if file is encrypted
	char	model[RFP_MAX_MODEL];				// Holds the <Model> data
	char	component[RFP_MAX_MODEL];			// Holds the <Component> data
	char	version[RFP_MAX_VERSION];			// Holds the <Version> data
	char	versionMin[RFP_MAX_VERSIONMIN];		// Holds the <VersionMin> data
	char	versionMax[RFP_MAX_VERSIONMAX];		// Holds the <VersionMax> data
	char	rsaKeyFile[RFP_MAX_FILENAME];		// Holds the <RSAKeyFile> data
	char	rc4KeyFile[RFP_MAX_FILENAME];		// Holds the <RC4KeyFile> data
	char *	tags;								// Holds unknown tags if CRFPParser::SetCopyUnknownTagsOption(1)
} RFP_FILE;

/** Structure holds the basic header information */

typedef struct
{
	char	title[RFP_MAX_TITLE];				// Holds the <Title> data
	char	description[RFP_MAX_DESCRIPTION];	// Holds the <Description> data
	char	copyRight[RFP_MAX_COPYRIGHT];		// Holds the <Copyright> data
	char	publisher[RFP_MAX_PUBLISHER];		// Holds the <Publisher> data
	char	model[RFP_MAX_MODEL];				// Holds the <Model> data
	char	version[RFP_MAX_VERSION];			// Holds the <Version> data
	char	versionMin[RFP_MAX_VERSIONMIN];		// Holds the <VersionMin> data
	char	versionMax[RFP_MAX_VERSIONMAX];		// Holds the <VersionMax> data
	int		isSigned;							// !0 if the header is signed
	int		autoRestart;						// secs before auto-restart, 0 means no auto restart
	int		disableOtherSessions;				// !0 if want to stop all other sessions during RFP
	char 	supportedDensity[RFP_MAX_SUPPORTED_DENSITY];	// list of supported Densities <SupportedDensity>
	char 	supportedHardware[RFP_MAX_SUPPORTED_HARDWARE];	// list of supported Hardware <SupportedHardware>  CLIPR_VERSION-MP_VERSION
	char	rsaKeyFile[RFP_MAX_FILENAME];		// Holds the <RSAKeyFile> data
	char *	tags;								// Holds unknown tags if CRFPParser::SetCopyUnknownTagsOption(1)
} RFP;

//----------------------------------------
//			Parser Class
//----------------------------------------

class CRFPParser : private CSXML
{
public:

	CRFPParser();
	virtual ~CRFPParser();

	int
	ParseHeader
	(
		char		*	pHeader			// Ptr to the NULL terminated header data
	);

	int									// Error Code
	ParseFile
	(
		CSIO		*	pSIO,					// SIO to read the data from
		int			*	pHeaderOffset=NULL,		// Returns offset into file of the header (usually 0)
		int			*	pHeaderLength=NULL,		// Returns length of the header
		int			*	pSignatureOffset=NULL,	// Returns offset to the signature
		int			*	pSignatureLength=NULL,	// Returns length of the signature (0 if no signature)
		int			*	pDataOffset=NULL		// Returns the offset to the first data file
	);

	int									// Error Code
	ParseHeaderAndSignature
	(
		char		*	pData,					// Ptr to the data
		int				length,					// length of the data
		int			*	pHeaderOffset=NULL,		// Returns offset into file of the header (usually 0)
		int			*	pHeaderLength=NULL,		// Returns length of the header
		int			*	pSignatureOffset=NULL,	// Returns offset to the signature
		int			*	pSignatureLength=NULL,	// Returns length of the signature (0 if no signature)
		int			*	pDataOffset=NULL		// Returns the offset to the first data file
	);

	void
	Free
	(
	);

	int
	VerifyHeaderSignature
	(
		char		*	pHeader,		// Ptr to the header data, NULL terminated
		char		*	pSignature,		// Ptr to the signature data (null terminated)
		char		*	pPublicKey		// Ptr File name of the public key in PEM format
	);

	int
	VerifyFileSignatures
	(
		char		*	pPublicKey		// Ptr to public key in PEM format
	);

	int
	VerifyFileSignature
	(
		RFP_FILE	*	pRFPFile,		// Description of file to check
		char		*	pTempFileName,	// Ptr to the temp file name or NULL to use actual name in pRFPFile
		char		*	pPublicKey		// Ptr File name of the public key in PEM format
	);

	int
	VerifySignature
	(
		CSIO		*	pSIO,			// Data source
		char		*	pSignature,		// Ptr to the signature data (null terminated)
		char		*	pPublicKey		// Ptr File name of the public key in PEM format
	);

	RFP_FILE *
	EnumFile
	(
		int				index
	);

	RFP *
	GetHeader
	(
	);

	inline int GetFileCount() { return fileCount; }

	inline void SetCopyUnknownTagsOption( int option ) { copyTags = option; }

private:

	virtual
	int
	Event
	(
		int			event
	);

	int
	State_Null
	(
		int			event
	);

	int
	State_RFP
	(
		int			event
	);

	int
	State_RFP_File
	(
		int			event
	);

	int
	State_String_Cat
	(
		int			event
	);

	// Parser data
	
	int		curFile;					// Index into rfpFile for current file

	RFP_FILE *pCurFile;					// Handy ptr to the current file
	int		fileCount;					// # of files i the package
	RFP_FILE *rfpFile[RFP_MAX_FILES];	// Ptrs to the RFP_FILE structure for each file
	RFP		rfp;						// The header structure
	char	*filePackageName;
	int		copyTags;					// !0 = Copy unknown tags into ->tags field of header and file structures
	char	**ppStr;					// Ptr to the string ptr we are copying the tag to

protected:
	inline void
	SetFilePackageName
	(
		char *fp
	);
};

inline void CRFPParser::SetFilePackageName ( char *fp) { filePackageName = fp; };

//----------------------------------------
//				Function Prototypes
//----------------------------------------

} // namespace

#endif	// _RFPParse_h_


