/**	
 *	@file	RFP_Protocol.h
 *	@brief	Definces the CCSCProtocol object for RDM
 *  This file defines the CRFP_Protocol_Factory and the CRFP_Protocol classes
 *  CRFP_Protocol_Factory is a CCSCProtocol object that is to be added to CSC
 *  When a new connetion is accepted, a thread is created and a CRFP_Protocol object is created
 */

#ifndef _RFP_Protocol_h_
#define _RFP_Protocol_h_

#include	"pp/CSCProtocol.h"
#include	"pp/Session.h"

class CNetConn;
namespace pp
{

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

//#define	RDM_IPR_RDM_CONDUIT_CLASS	0xA948535f

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/** RFP Message structure */

#pragma pack(1)
typedef struct
{
	WORD	cmdLength;		// # of bytes in the message
	BYTE	command;		// The message type/command
	BYTE	pktID;			// Sequence information
	DWORD	phase;			// RFP Transfer phase (RFP_PHASE_)
	DWORD	data;			// file length on start or error code on cancel or done
} RFP_MESSAGE_HEADER;

typedef struct
{
	RFP_MESSAGE_HEADER	header;			// Header, see above
	BYTE				data[4096-12];	// Message data
} RFP_MESSAGE;
#pragma pack()

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

class RFP_Protocol_Unpack;

/*----------------------------------------
 *	CRFP_Protocol_Factory Class
 *--------------------------------------*/

class CRFP_Protocol_Factory : public CCSCProtocol
{
public:

	CRFP_Protocol_Factory() : CCSCProtocol("RFP","SSL","1","1","None","CSC") {}

	/**
	 *	@brief	Override of CCSCProtocol::AcceptClientSocket
	 * 
	 *  Called when and "RFP" protocol TCP connection is accepted
	 *
	 *  @see CCSCProtocol
	 *
	 *  @param	pSession		The user session for this connection
	 * 	@param	s				The socket
	 *  @param	ipAddress		The client IP address
	 *  @param	tcpPort			The client TCP Port
	 */
public:
	virtual void AcceptClientSocket(CSession *pSession, CNetConn *pNetConn, int ipAddress, int tcpPort);
};

/*----------------------------------------
 *	CRFP_Protocol Class
 *--------------------------------------*/

class	CRFP_Protocol : public CSessionObject
{
public:

	CRFP_Protocol( CNetConn *pNetConn, CSession * pSession );

	virtual ~CRFP_Protocol();

	/** @see Session.h - CSessionObect */

	void
	Event
	(
		CSession	* pUserSession,		// The session in question...
		int			event,				// Which SESSION_EVENT_ code
		const void		*pData				// Data associated with the event
	);

	void
	Process
	(
	);

	// Processing Functions

	int StartRequest( RFP_MESSAGE * pMsg );
	int RequestData( RFP_MESSAGE * pMsg );
	int RequestDone( RFP_MESSAGE * pMsg );
	int StartReceive( RFP_MESSAGE * pMsg );
	int ReceiveData( RFP_MESSAGE * pMsg );
	int ReceiveDone( RFP_MESSAGE * pMsg );
	int Cancel( int error );
	int GotoNull( int error );
	int SendRFPMessage( int phase, int data );
	int SendRFPMessage( RFP_MESSAGE * pRFP );

private:
	OS_THREAD	hThread;				// Handle to our thread
	CNetConn *	pNetConn;			  	// Ptr to the network connection
	CSession *	pSession;				// Ptr to the session we are attached to

	int			state;					// State Machine state
	char	*	reqBuffer;				// Request header buffer
	int			expectedLength;			// # of bytes we are expecting
	int			receivedLength;			// # of bytes received
	RFP_Protocol_Unpack	* pUnpack;		// Ptr to the RFP Unpacker
};

} // Namespace

#endif // _RFP_Protocol_h_


