/*-------------------------------------------------------------------------------

	SIO_FP_Encrypted.cpp

	Copyright (c) 2002, Raritan Computer, Inc.

	An simple IO object. Simular in concept to the BIO found in the SSL libray.

	CSIO_FP_Encrypted uses POSIX file file functions and encrypts/decrypts the data

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<stdarg.h>
#include	<ctype.h>
#include	<pp/syms.h>
#include	<pp/SIO_FP_Encrypted.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CSIO_FP
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSIO_FP_Encrypted::CSIO_FP_Encrypted
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	CSIO_FP_Encrypted::~CSIO_FP_Encrypted
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	Close();
}

//--------------------------------------------------------------------------------
//
	void
	CSIO_FP_Encrypted::SetKey
	(
		const u_char	*pData,			// Were to put the data
		int		length			// # to read
	)
//
//	Sets the RC4 key
//
//------------------------------------------------------------------------------//
{
	RC4_set_key( &key, length, pData);
}

//--------------------------------------------------------------------------------
//
	int									// returns bytes read or error code (POSIX)
	CSIO_FP_Encrypted::Read
	(
		char	*	pData,			// Were to put the data
		int		count			// # to read
	)
//
//	Reads data from the SIO object
//
//------------------------------------------------------------------------------//
{
	int		result;

	result = CSIO_FP::Read( pData, count );

	// Decrypt
	if (result > 0)
		RC4( &key, result, (unsigned char *) pData, (unsigned char *) pData );

	return result;
}


//--------------------------------------------------------------------------------
//
	int									// returns bytes written or error code (POSIX)
	CSIO_FP_Encrypted::Write
	(
		char	*	pData,			// Data to write
		int		count			// # to write
	)
//
//	Writes data to the SIO object
//
//------------------------------------------------------------------------------//
{
	int		result;

	// Encrypt
	/*
	 * FIXME: reading and writing in same buffer isn't quite good design
	 *	  it also preevents "const" usage on input buffer
	 */
	RC4( &key, count, (unsigned char *) pData, (unsigned char *) pData );

	result = CSIO_FP::Write( pData, count );

	return result;
}

//--------------------------------------------------------------------------------
//
	int					// 0 or error code (POSIX)
	CSIO_FP_Encrypted::Seek
	(
		int	NOTUSED(offset),	// Number of bytes from the origin
		int	NOTUSED(origin)		// SEEK_SET, SEEK_CUR, SEEK_END
	)
//
//	Seeks into the file
//
//------------------------------------------------------------------------------//
{
	return -1;
}

//--------------------------------------------------------------------------------
//
	int									// returns current position or error code (POSIX)
	CSIO_FP_Encrypted::Size
	(
	)
//
//	Returns the size of the file
//
//------------------------------------------------------------------------------//
{
	return -1;
}


