/*----------------------------------------------------------------------------

	CircularFile.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for CircularFile.cpp

----------------------------------------------------------------------------*/

#ifndef _CircularFile_H_
#define	_CircularFile_H_

#include "pp/SIO.h"


//----------------------------------------
//				Equates
//----------------------------------------

#define	CF_OLDEST				0x80000000
#define	CF_NEWEST				0x7FFFFFFF
#define	CF_LENGTH_SIZE			1
#define	CF_MAX_SIZE				255
#define	CF_LENGTH_TYPE			unsigned char

//----------------------------------------
//				Data Types
//----------------------------------------

	// Header for all circular files

typedef struct
{
	int		signature;					// Circular file signature
	int		maxSize;					// Max size of the file
	int		usedSize;					// # of bytes used in the file
	int		lengthSize;					// Size of the length (1,2,4)
	int		gapPosition;				// Starting point of he gap
	int		gapLength;					// length of the gap
	int		userData;					// User defined
} CF_HEADER;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Fucntions
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class CCircularFile
{
public:

	CCircularFile();
	virtual ~CCircularFile();

	int									// <0 = error, 0 = initialized, 1 = ok
	Initialize
	(
		CSIO	*	pFile,				// The working file
		int			size				// Desired size of the file
	);

	int								// 0 or error code
	Write
	(
		char	*	pData			// Ptr to the entry data to write
	);

	int								// 0 or error code
	Write
	(
		char	*	pData1,			// Ptr to the entry data to write
		int			length1,		// # of bytes of data to write
		char	*	pData2 = NULL,	// Second segment
		int			length2 = 0,	// 
		char	*	pData3 = NULL,	// Third segment
		int			length3 = 0,	// 
		char	*	pData4 = NULL,	// Fourth segment
		int			length4 = 0		// 
	);

	int								// # of bytes read or error code
	Read
	(
		char	*	pData,			// Where to put the data
		int			maxLength = 0,	// Max # of bytes that can be written to pData
									// Default = 0 = no limit
		int			direction = 1	// >=0 = read next entry
									// < 0 = read previous entry
									// 0 = Don't move file position
	);

	void
	Rewind
	(
	);

	int									// # of entries moved
	Seek
	(
		int		distance				// # of entries to move
										// negative = move backwards
										// CF_FIRST = moves to first entry (oldest)
										// CF_LAST  = moves ot last entry (newest)
	);

	int								// 0 or error code
	Flush
	(
	);

	int								// 0 or error code
	Sync
	(
		CSIO	*pDestFile			// File to write to
	);

	inline
	void
	SetUserData( int data )
	{
		header.userData = data;
		writeHeader = 1;
	}

	inline
	int
	GetUserData(  )
	{
		return header.userData;
	}

	// ------------------------------

private:

	int								// 0 or error code
	WrapSeek
	(
		int		position
	);

	int								// 0 or error code
	WrapRead
	(
		char	*	pData,			// Where to put the data
		int			length			// # of bytes to read
	);

	int								// 0 or error code
	WrapWrite
	(
		char	*	pData,			// Where to put the data
		int			length			// # of bytes to read
	);

private:

	CSIO		*	pFile;				// The SIO file object
	CF_HEADER		header;				// copy of the header
	int				writeHeader;		// !0 if the header needs to be written
	int				needSync;			// !0 = we need to sync if sync is called
	int				syncPosition;		// First byte written to since last Sync
	int				syncLength;			// # of bytes to update
	int				seekPosition;		// The last WrapSeek position
	int				rdPosition;			// Current read position
};

#endif // _CircularFile_H_
