/*--------------------------------------------------------------------------------

	SXDB_Parse.cpp

	Copyright (c) 2002, Raritan Computer, Inc.

	This class parses an XML file into SXDB nodes

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"pp/SXDB_Parse.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CSXDB_Node
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Parse::CSXDB_Parse
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	pDB = NULL;
	pNode = NULL;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Parse::~CSXDB_Parse
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	if (pDB != NULL)
		delete pDB;

	pDB = NULL;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *
	CSXDB_Parse::Root
	(
	)
//
//	Returns the root node after parsing.
//
//------------------------------------------------------------------------------//
{
	return pDB->Root();
}

//--------------------------------------------------------------------------------
//
	CSXDB *
	CSXDB_Parse::GetDataBase
	(
	)
//
//	Returns the database after parsing.
//
//------------------------------------------------------------------------------//
{
	return pDB;
}

//--------------------------------------------------------------------------------
//
	CSXDB *
	CSXDB_Parse::UnlinkDataBase
	(
	)
//
//	Unlinks the database and all of it's children from the parser object.
//	If the user wants the parsed nodes to live beyond the life of
//	this CSXDB object, then the database must be unlinked.
//
//------------------------------------------------------------------------------//
{
	CSXDB	* p = pDB;

	pDB = NULL;

	return p;
}

//--------------------------------------------------------------------------------
//
	int
	CSXDB_Parse::Event
	(
		int			event
	)
//
//	Creates nodes for each part of the xml file.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Element *	result;

	if (event == SXML_EVENT_START_DOCUMENT)
	{
		if (pDB != NULL)
			delete pDB;

		pDB = new CSXDB;
		pNode = (CSXDB_Element *) pDB->Root();;

		return 0;
	}

	if (pNode == NULL)
		return SXML_ERROR_OUT_OF_MEMORY;

	// Write tags out to file

	switch (event)
	{
		case SXML_EVENT_START_TAG:
			pNode = pNode->AddElement( GetName() );
			break;

		case SXML_EVENT_END_TAG:
			pNode = (CSXDB_Element *) pNode->Parent();
			break;

		case SXML_EVENT_ATTRIBUTE:
			result = (CSXDB_Element *) pNode->AddAttribute( GetName(), GetData() );
			if (result == NULL)
				return SXML_ERROR_OUT_OF_MEMORY;
			break;

		case SXML_EVENT_DATA:
			result = (CSXDB_Element *) pNode->AddData( GetData() );
			if (result != 0)
				return SXML_ERROR_OUT_OF_MEMORY;
			break;

		case SXML_EVENT_CDATA:
			break;

		default:
			break;
	}


	return 0;
}

