/*--------------------------------------------------------------------------------

	SXDB_Cmd.h

	Copyright (c) 2002, Raritan Computer, Inc.

	Header file for SXDB_Cmd.cpp

--------------------------------------------------------------------------------*/

#ifndef _SXDB_CMD_H_
#define	_SXDB_CMD_H_

#include "pp/SXML_Errors.h"
#include "pp/SXDB.h"
#include "pp/SXML.h"
#include "pp/SXDB_Parse.h"

//----------------------------------------
//				Equates
//----------------------------------------
	// Field Lengths

#define	SXCMD_MAX_DATABASE_NAME		16	// Max length of the database name
#define	SXCMD_MAX_ROOT_PATH			256	// Max length of an XPath statement

	// Command IDs

enum SXCMD_ID
{
	SXCMD_UNKNOWN,
	SXCMD_GET,
	SXCMD_UPDATE,
	SXCMD_APPEND,
	SXCMD_DELETE,
	SXCMD_COUNT,
	SXCMD_LOCK,
	SXCMD_UNLOCK
};

	// Parser States

enum
{
	SXCMD_STATE_NULL = 0,
	SXCMD_STATE_DATABASE,
	SXCMD_STATE_GET,
	SXCMD_STATE_XPATH,
	SXCMD_STATE_APPEND_UPDATE,
	SXCMD_STATE_DATA
};

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	int									// SXML_ERROR_
	SXDB_Cmd
	(
		CSIO	*	pIn,				// Input commands
		CSIO	*	pOut,				// Output results
		CSXDB	*	pDB					// The data base
	);

	void
	SXDB_Cmd_Error
	(
		CSIO	*	pOut,				// Output results
		int			error				// error code
	);

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

		// SXCMD Class
		// This class represents a single command (<Get> <Count>, etc)

class CSXCMD
{
public:

	CSXCMD();

	~CSXCMD();

	class CSXCMD * pNext;				// Linked list ptr
	SXCMD_ID	cmdID;					// Which command to execute
	CSXDB	*	pDB;					// Database of new data associated with the command
	char		rootPath[SXCMD_MAX_ROOT_PATH];	// XPath statement 
	char	*	pNodes;					// Ptr to the <Nodes> data
	char	*	pSubNodes;				// Ptr to the <SubNodes> data
	int			depth;					// # of levels down

};

		// SXCMD_Parser class
		// This class represents a list of commands within a <Database> element

class CSXCMD_List : public CSXML_SIO
{
public:

	CSXCMD_List();

	~CSXCMD_List();

	CSXCMD	*pCmdList;					// Ptr to the first parsed command

	char	databaseName[SXCMD_MAX_DATABASE_NAME];

private:

	int
	Event
	(
		int			event
	);

	int
	State_Null
	(
		int			event
	);

	int
	State_Database
	(
		int			event
	);

	int
	State_Get
	(
		int			event
	);

	int
	State_XPath
	(
		int			event
	);

	int
	State_Append_Update
	(
		int			event
	);

	int
	State_Data
	(
		int			event
	);

	int
	AddCmd
	(
		SXCMD_ID		id
	);

	CSXCMD	*pCmd;						// Ptr to the current command
	CSXDB_Element	*	pNode;			// Ptr to the current node being added in a <Data> section

};

#endif	// _SXDB_CMD_H_

